/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.gni.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.edgemind.ibee.core.gni.IGni;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.domain.ImfComponentType;
import net.edgemind.ibee.core.iml.model.IContainer;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.ImfComponent;
import net.edgemind.ibee.core.iml.model.ImfNamedElement;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.util.ImfElementFinder;
import net.edgemind.ibee.core.util.ImfUtilityFactory;
import net.edgemind.ibee.util.misc.IFilter;

public class ImfGniImpl
implements IGni<IElement, IElementType<? extends IElement>> {
    private IbeeResource resource;
    private ImfElementFinder finder = ImfUtilityFactory.getInstance().createFinder();

    public ImfGniImpl(IbeeResource resource) {
        this.resource = resource;
    }

    public IbeeResource getResource() {
        return this.resource;
    }

    @Override
    public IElementType<? extends IElement> getType(IElement node) {
        return node.giGetElementType();
    }

    @Override
    public IElement getParent(IElement node) {
        return node.giGetParent();
    }

    @Override
    public List<IElement> getChildren(IElement node) {
        return this.finder.findElements(node, (IFilter<IElement>)null, false);
    }

    @Override
    public IElement create(IElementType<? extends IElement> type) {
        IElement child = type.getDomain().create(type);
        return child;
    }

    @Override
    public boolean append(IElement node, IElement child) {
        IContainer<ImfComponent> container;
        if (node instanceof ImfComponent && child.giGetElementType() instanceof ImfComponentType && (container = node.getContainer((ImfComponentType)child.giGetElementType()).toGeneric()) != null) {
            container.add((ImfComponent)child);
            return true;
        }
        return false;
    }

    @Override
    public boolean append(IElement node, IElement child, String feature) {
        IFeature f = node.giGetElementType().getFeature(feature);
        if (f instanceof IListFeature) {
            node.giGetList((IListFeature)f).add(child);
            return true;
        }
        if (f instanceof IElementFeature && node.giGetElement((IElementFeature)f).getElement() == null) {
            node.giGetElement((IElementFeature)f).setElement(child);
            return true;
        }
        return false;
    }

    @Override
    public boolean setValue(IElement node, String feature, String value) {
        node.giSetAttribute(feature, value);
        return true;
    }

    @Override
    public String getValue(IElement node, String feature) {
        return node.giGetAttribute(feature);
    }

    @Override
    public String getRawValue(IElement node, String feature) {
        IAttributeFeature attrFeature = node.giGetElementType().getAttributeFeature(feature);
        if (attrFeature != null) {
            return node.giGetAttributeRaw(attrFeature);
        }
        return null;
    }

    @Override
    public List<IElement> getChildren(IElement node, String feature) {
        Object e;
        ArrayList<IElement> res = new ArrayList<IElement>();
        IFeature f = node.giGetElementType().getFeature(feature);
        if (f instanceof IListFeature) {
            res.addAll(node.giGetList((IListFeature)f).getElements());
        }
        if (f instanceof IElementFeature && (e = node.giGetElement((IElementFeature)f).getElement()) != null) {
            res.add((IElement)e);
        }
        return res;
    }

    @Override
    public boolean remove(IElement node) {
        IElement parent = node.giGetParent();
        if (parent != null) {
            IFeature feature = parent.giGetFeatureOf(node);
            if (feature instanceof IListFeature) {
                parent.giGetList((IListFeature)feature).remove(node);
                return true;
            }
            if (feature instanceof IElementFeature) {
                parent.giGetElement((IElementFeature)feature).setElement(null);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean dispose(IElement node) {
        if (node.isRemoved()) {
            return false;
        }
        node.remove();
        return true;
    }

    @Override
    public boolean isNamed(IElement node) {
        return node instanceof ImfNamedElement;
    }

    @Override
    public String getName(IElement node) {
        if (this.isNamed(node)) {
            return ((ImfNamedElement)node).getName();
        }
        return "";
    }

    @Override
    public void setName(IElement node, String name) {
        if (this.isNamed(node)) {
            ((ImfNamedElement)node).setName(name);
        }
    }

    @Override
    public Collection<IElement> findNodes(String specifier) {
        return this.resource.getAllObjects(true);
    }

    @Override
    public IElement findFirst(String specifier) {
        return null;
    }

    @Override
    public Collection<String> getFeatures(IElement node) {
        return node.giGetElementType().getAllFeatures().stream().map(f -> f.getName()).collect(Collectors.toList());
    }

    @Override
    public IGni.FeatureType getFeatureType(IElement node, String feature) {
        if (node.giGetElementType().getAttributeFeature(feature) != null) {
            return IGni.FeatureType.Attribute;
        }
        if (node.giGetElementType().getElementFeature(feature) != null) {
            return IGni.FeatureType.Node;
        }
        if (node.giGetElementType().getListFeature(feature) != null) {
            return IGni.FeatureType.Node;
        }
        return null;
    }

    @Override
    public Collection<IElement> getAllComponents() {
        return this.resource.getAllObjects();
    }

    @Override
    public IGni.NodeType getNodeType(IElement node) {
        if (node.isComponent()) {
            return IGni.NodeType.Component;
        }
        if (node.isReference()) {
            return IGni.NodeType.Reference;
        }
        return IGni.NodeType.Data;
    }

    @Override
    public Collection<IElement> getAllComponents(IElementType<? extends IElement> type) {
        return this.resource.getGlobalElements(type, false, false, null).stream().collect(Collectors.toList());
    }

    @Override
    public String getTypeName(IElementType<? extends IElement> type) {
        return type.getName();
    }
}

