/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.domain;

import net.edgemind.ibee.core.iml.domain.Version;

public class VersionComparator {
    public boolean greaterOrEquals(String version1, String version2) {
        return this.greaterOrEquals(this.parseVersion(version1), this.parseVersion(version2));
    }

    public boolean greaterOrEquals(Version version1, Version version2) {
        return this.compareVersions(version1, version2, (a, b) -> a >= b);
    }

    public boolean greater(String version1, String version2) {
        return this.greater(this.parseVersion(version1), this.parseVersion(version2));
    }

    public boolean greater(Version version1, Version version2) {
        return this.compareVersions(version1, version2, (a, b) -> a > b);
    }

    public boolean lessOrEquals(String version1, String version2) {
        return this.lessOrEquals(this.parseVersion(version1), this.parseVersion(version2));
    }

    public boolean lessOrEquals(Version version1, Version version2) {
        return this.compareVersions(version1, version2, (a, b) -> a <= b);
    }

    public boolean less(String version1, String version2) {
        return this.less(this.parseVersion(version1), this.parseVersion(version2));
    }

    public boolean less(Version version1, Version version2) {
        return this.compareVersions(version1, version2, (a, b) -> a < b);
    }

    public boolean equals(String version1, String version2) {
        return this.equals(this.parseVersion(version1), this.parseVersion(version2));
    }

    public boolean equals(Version version1, Version version2) {
        return this.compareVersions(version1, version2, (a, b) -> a == b);
    }

    public boolean isBackwardCompatible(String higherVersion, String lowerVersion) {
        return this.isBackwardCompatible(this.parseVersion(higherVersion), this.parseVersion(lowerVersion));
    }

    public boolean isBackwardCompatible(Version higherVersion, Version lowerVersion) {
        if (this.getMajor(higherVersion) != this.getMajor(lowerVersion)) {
            return false;
        }
        if (this.getMinor(higherVersion) < this.getMinor(lowerVersion)) {
            return false;
        }
        return this.getMinor(higherVersion) != this.getMinor(lowerVersion) || this.getMaint(higherVersion) >= this.getMaint(lowerVersion);
    }

    private Version parseVersion(String versionString) {
        return Version.fromString(versionString);
    }

    private boolean compareVersions(Version version1, Version version2, IVersionComparator vPartComparator) {
        int part1 = this.encodeBetween0And2(version1.major, version2.major);
        int part2 = this.encodeBetween0And2(version1.minor, version2.minor);
        int part3 = this.encodeBetween0And2(version1.maint, version2.maint);
        int compareId = 100 * part1 + 10 * part2 + part3;
        int equalsCompareId = 111;
        return vPartComparator.compare(compareId, equalsCompareId);
    }

    private int encodeBetween0And2(int part1, int part2) {
        return part1 > part2 ? 2 : (part1 == part2 ? 1 : 0);
    }

    private int getMajor(Version version) {
        return version.major;
    }

    private int getMinor(Version version) {
        return version.minor;
    }

    private int getMaint(Version version) {
        return version.maint;
    }

    private static interface IVersionComparator {
        public boolean compare(int var1, int var2);
    }
}

