/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.domain.impl;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.impl.FeatureImpl;
import net.edgemind.ibee.core.iml.model.IElement;

public class ElementFeatureImpl<T extends IElement>
extends FeatureImpl
implements IElementFeature<T> {
    private List<IElementType<? extends T>> types = new ArrayList<IElementType<? extends T>>();
    private boolean isContainment = false;
    private boolean isAutoCreate = false;

    public ElementFeatureImpl() {
    }

    @Override
    public IElementType<T> getElementType() {
        return super.getElementType();
    }

    public ElementFeatureImpl(String name) {
        this.setName(name);
    }

    public ElementFeatureImpl(String name, IElementType<T> type) {
        this.setName(name);
        this.types.add(type);
    }

    public ElementFeatureImpl<T> addType(IElementType<? extends T> type) {
        this.types.add(type);
        return this;
    }

    @Override
    public List<IElementType<? extends T>> getTypes() {
        return this.types;
    }

    @Override
    public boolean isContainment() {
        return this.isContainment;
    }

    public void isContainment(boolean value) {
        this.isContainment = value;
    }

    @Override
    public boolean isAutoCreate() {
        return this.isAutoCreate;
    }

    public void isAutoCreate(boolean value) {
        this.isAutoCreate = value;
    }

    @Override
    public boolean isGlobal() {
        if (this.getTypes().size() > 0) {
            return this.getTypes().get(0).isGlobal();
        }
        return false;
    }

    @Override
    public boolean isReference() {
        return this.types.stream().allMatch(type -> type.isReferenceType());
    }
}

