/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.model.impl;

import java.util.Collection;
import net.edgemind.ibee.core.context.IContext;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IBasicReferenceType;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.ImfComponentType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IProxy;
import net.edgemind.ibee.core.iml.model.ImfReference;
import net.edgemind.ibee.core.resource.GlobalKey;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.util.ModelUtilImf;
import net.edgemind.ibee.util.string.StringUtil;

public class DefaultProxy
implements IProxy {
    @Override
    public IElement resolve(ImfReference ref, IContext context) {
        if (ref == null) {
            return null;
        }
        IbeeResource resource = ref.giGetResource();
        if (resource == null) {
            return null;
        }
        if (ref.giGetElementType() instanceof IBasicReferenceType) {
            IElementType<?> targetType = ref.giGetElementType().getTargetTypes().get(0);
            if (ref.giGetElementType().isIdBased()) {
                Long id = StringUtil.toLong((String)ref.giGetAttribute("id"), null);
                return resource.getComponentById((ImfComponentType)targetType, id);
            }
            resource = ModelUtilImf.getMainResource(resource, context);
            GlobalKey<ImfReference> targetKey = this.createGlobalKey(targetType);
            GlobalKey<ImfReference> refKey = GlobalKey.createFrom(ref);
            if (refKey.isEmpty()) {
                return null;
            }
            targetKey.importData(refKey);
            Collection<?> targets = resource.getGlobalElements(targetKey, false, true);
            String refNs = ref.resolveNamespace();
            for (IElement target : targets) {
                String targetNs = target.resolveNamespace();
                if (!targetNs.equalsIgnoreCase(refNs)) continue;
                return target;
            }
        }
        return null;
    }

    private <T extends IElement> GlobalKey<T> createGlobalKey(IElementType<T> targetType) {
        GlobalKey<T> key = new GlobalKey<T>(targetType);
        return key;
    }

    @Override
    public void setTarget(ImfReference ref, IElement target) {
        String targetNs;
        String refNs;
        if (ref == null) {
            return;
        }
        IbeeResource resource = ref.giGetResource();
        if (resource == null) {
            return;
        }
        if (ref.giGetElementType() instanceof IBasicReferenceType) {
            for (IAttributeFeature attr : ref.giGetElementType().getAttributeFeatures()) {
                if (!attr.isKey()) continue;
                if (target == null) {
                    ref.giSetAttribute(attr, "");
                    continue;
                }
                ref.giSetAttribute(attr, target.giGetAttribute(attr.getName()));
            }
        }
        if (!(refNs = ref.resolveNamespace()).equalsIgnoreCase(targetNs = target.resolveNamespace())) {
            ref.setNamespace(targetNs);
        }
    }
}

