/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.model.impl;

import net.edgemind.ibee.core.iml.LockedElementException;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IElementHandle;
import net.edgemind.ibee.core.iml.model.impl.ElementImpl;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.impl.IbeeResourceImpl;

public class ElementHandleImpl<T extends IElement>
implements IElementHandle<T> {
    private static final long serialVersionUID = 1L;
    private long id = -1L;
    private IElement parent;
    private IElementFeature<T> feature;

    public ElementHandleImpl(IElement parent, IElementFeature<T> feature) {
        this.parent = parent;
        this.feature = feature;
    }

    public synchronized IElement getParent() {
        return this.parent;
    }

    @Override
    public synchronized T getElement() {
        IElementFeature<T> feature;
        IbeeResource model = this.parent.giGetResource();
        if (model == null) {
            return null;
        }
        IElement res = null;
        if (this.id >= 0L) {
            res = model.getObject(this.id);
        }
        if (res == null && (feature = this.getFeature()).isAutoCreate()) {
            IElementType<T> typeToCreate = feature.getTypes().get(0);
            T newElement = typeToCreate.getDomain().create(typeToCreate);
            this.setElementInternal(newElement, true);
            return newElement;
        }
        return (T)res;
    }

    @Override
    public synchronized void unset() {
        this.setElement(null);
    }

    @Override
    public synchronized void setElement(T element) {
        this.setElementInternal(element, false);
    }

    private synchronized void setElementInternal(T element, boolean autocreated) {
        if (element == null && this.id == -1L || element != null && element.giGetElementId() == this.id && this.id != -1L) {
            return;
        }
        long oldValue = this.id;
        if (element != null) {
            this.validateElementToAdd((IElement)element);
            this.addElementToResource((IElement)element);
            this.setParent((IElement)element);
        }
        this.id = element == null ? -1L : element.giGetElementId();
        IElementFeature<T> feature = this.getFeature();
        if (oldValue != -1L && feature.isContainment()) {
            IbeeResource model = this.parent.giGetResource();
            IElement oldElement = model.getObject(oldValue);
            this.unsetParent(oldElement);
        }
        if (!autocreated && this.notifyFeatureChange()) {
            this.notify(oldValue, this.id);
        }
    }

    public synchronized void setElementByIdInject(Long newId, boolean notify) {
        Long oldValue = this.id;
        this.id = newId == null ? -1L : newId;
        if (notify || this.feature.isKey() && this.alwaysNotifyKeyChanges()) {
            this.notify(oldValue, newId);
        }
    }

    private boolean alwaysNotifyKeyChanges() {
        IbeeResourceImpl res = (IbeeResourceImpl)this.parent.giGetResource();
        return res != null && res.getAlwaysNotifyKeyChanges();
    }

    public synchronized long getElementId() {
        return this.id;
    }

    private synchronized void notify(Long oldValue, Long newValue) {
        if (this.parent == null) {
            return;
        }
        ((ElementImpl)this.parent).giNotify(this.getFeature(), oldValue, newValue);
    }

    private synchronized void validateElementToAdd(IElement element) {
        if (element == null) {
            return;
        }
        IElementFeature<T> feature = this.getFeature();
        if (this.parent.isProtected(feature)) {
            throw new LockedElementException(element);
        }
        IbeeResource resource = this.parent.giGetResource();
        if (resource == null) {
            throw new RuntimeException("element '" + this.parent.giGetElementType().getName() + "' is not in a resource");
        }
        if (element.giGetResource() != null && element.giGetResource() != resource) {
            throw new RuntimeException("element '" + element.giGetElementType().getName() + "' is contained in a different resource");
        }
        if (element.giGetResource() == null && !feature.isContainment()) {
            throw new RuntimeException("element '" + element.giGetElementType().getName() + "' is not contained in a resource");
        }
        if (this.parent.isProtected(this.getFeature())) {
            throw new LockedElementException(this.parent);
        }
    }

    private synchronized void addElementToResource(IElement element) {
        if (this.feature.isContainment()) {
            boolean contains;
            IElement currentParent = element.giGetParent();
            if (currentParent != null && currentParent != this.parent) {
                throw new RuntimeException("element " + element.giGetElementType().getName() + " has already another parent");
            }
            IbeeResource resource = this.parent.giGetResource();
            boolean bl = contains = resource.getObject(element.giGetElementId()) == element;
            if (!contains) {
                resource.putObject(element);
            }
        }
    }

    private synchronized void setParent(IElement element) {
        if (element == null) {
            return;
        }
        if (this.feature.isContainment()) {
            ((ElementImpl)element).giSetParent(this.parent, this.feature);
        }
    }

    private synchronized void unsetParent(IElement element) {
        if (element == null) {
            return;
        }
        if (this.feature.isContainment()) {
            ((ElementImpl)element).giSetParent(null, null);
        }
    }

    protected boolean notifyFeatureChange() {
        return this.parent.notifyFeatureChange(this.feature);
    }

    @Override
    public IElementFeature<T> getFeature() {
        return this.feature;
    }

    @Override
    public boolean isSet() {
        if (this.id == -1L) {
            return false;
        }
        IbeeResource model = this.parent.giGetResource();
        if (model == null) {
            return false;
        }
        return model.getObject(this.id) != null;
    }
}

