/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.iml.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.edgemind.ibee.core.iml.LockedElementException;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IListHandle;
import net.edgemind.ibee.core.iml.model.impl.ElementImpl;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.impl.IbeeResourceImpl;

public abstract class ListHandleImpl<T extends IElement>
implements IListHandle<T>,
Collection<T> {
    private static final long serialVersionUID = 1L;
    protected Collection<Long> ids;
    protected IElement parent;
    protected IListFeature<T> feature;

    public ListHandleImpl(IElement parent, IListFeature<T> feature) {
        this.parent = parent;
        this.feature = feature;
    }

    public synchronized IElement getParent() {
        return this.parent;
    }

    public synchronized Collection<Long> getIds() {
        return this.ids;
    }

    @Override
    public synchronized void addElements(Collection<? extends T> elements) {
        if (elements == null) {
            return;
        }
        List<Long> oldValue = null;
        if (this.notifyFeatureChange()) {
            oldValue = this.getAllElementIds();
        }
        for (IElement element : elements) {
            this.addElementInternal(element, -1);
        }
        if (this.notifyFeatureChange()) {
            this.notify(oldValue, this.getAllElementIds());
        }
    }

    @Override
    public synchronized T addElement(T element) {
        return this.addElementByIndex(element, -1);
    }

    private synchronized void addElementInternal(IElement element, int index) {
        Long elementIdToAdd = element.giGetElementId();
        if (this.feature.isContainment() && this.ids.contains(elementIdToAdd)) {
            return;
        }
        this.validateElementToAdd(element);
        this.addElementToResource(element);
        this.insertId(element.giGetElementId(), index);
        this.setParent(element);
    }

    protected synchronized T addElementByIndex(T element, int index) {
        List<Long> oldValue = null;
        if (this.notifyFeatureChange()) {
            oldValue = this.getAllElementIds();
        }
        this.addElementInternal((IElement)element, index);
        if (this.notifyFeatureChange()) {
            this.notify(oldValue, this.getAllElementIds());
        }
        return element;
    }

    protected void insertId(long id, int index) {
        this.ids.add(id);
    }

    private synchronized void setParent(IElement element) {
        if (element == null) {
            return;
        }
        if (this.feature.isContainment()) {
            ((ElementImpl)element).giSetParent(this.parent, this.feature);
        }
    }

    private synchronized void unsetParent(IElement element) {
        if (element == null) {
            return;
        }
        if (this.feature.isContainment()) {
            ((ElementImpl)element).giSetParent(null, null);
        }
    }

    @Override
    public synchronized void clearElements() {
        if (this.ids.isEmpty()) {
            return;
        }
        List<Long> oldValue = this.getAllElementIds();
        this.ids.clear();
        if (this.feature.isContainment()) {
            IbeeResource model = this.parent.giGetResource();
            for (Long oldId : oldValue) {
                IElement element = model.getObject(oldId);
                this.unsetParent(element);
            }
        }
        if (this.notifyFeatureChange()) {
            this.notify(oldValue, this.getAllElementIds());
        }
    }

    @Override
    public synchronized void removeElement(IElement element) {
        if (element == null) {
            return;
        }
        if (this.parent.isProtected(this.feature)) {
            throw new LockedElementException(this.parent);
        }
        List<Long> oldValue = null;
        if (this.notifyFeatureChange()) {
            oldValue = this.getAllElementIds();
        }
        ArrayList<Long> newIds = new ArrayList<Long>();
        for (long id : this.ids) {
            if (id == element.giGetElementId()) continue;
            newIds.add(id);
        }
        this.ids = newIds;
        this.unsetParent(element);
        if (this.notifyFeatureChange()) {
            this.notify(oldValue, this.getAllElementIds());
        }
    }

    public synchronized List<Long> getAllElementIds() {
        if (this.ids == null) {
            return new ArrayList<Long>();
        }
        return new ArrayList<Long>(this.ids);
    }

    @Override
    public synchronized List<T> getElements() {
        ArrayList<IElement> result = new ArrayList<IElement>();
        IbeeResource model = this.parent.giGetResource();
        if (model == null) {
            return result;
        }
        for (long id : this.ids) {
            IElement element = model.getObject(id);
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    public synchronized void setElements(Collection<? extends T> elements) {
        List<Long> oldValue = this.getAllElementIds();
        this.ids.clear();
        if (elements != null) {
            for (IElement element : elements) {
                this.addElementInternal(element, -1);
            }
        }
        if (this.feature.isContainment()) {
            IbeeResource model = this.parent.giGetResource();
            for (Long oldId : oldValue) {
                if (this.ids.contains(oldId)) continue;
                IElement element = model.getObject(oldId);
                this.unsetParent(element);
            }
        }
        if (this.notifyFeatureChange()) {
            this.notify(oldValue, this.getAllElementIds());
        }
    }

    protected boolean notifyFeatureChange() {
        return this.parent.notifyFeatureChange(this.feature);
    }

    public synchronized void setAllElementsByIdInject(List<Long> newIds, boolean notify) {
        boolean requiresNotify = notify || this.feature.isKey() && this.alwaysNotifyKeyChanges();
        List<Long> oldIds = null;
        if (requiresNotify) {
            oldIds = this.getAllElementIds();
        }
        this.ids.clear();
        if (newIds != null) {
            for (Long newId : newIds) {
                if (this.getFeature().isContainment() && this.ids.contains(newId)) continue;
                this.ids.add(newId);
            }
        }
        if (requiresNotify) {
            this.notify(oldIds, newIds);
        }
    }

    private boolean alwaysNotifyKeyChanges() {
        IbeeResourceImpl res = (IbeeResourceImpl)this.parent.giGetResource();
        return res != null && res.getAlwaysNotifyKeyChanges();
    }

    protected synchronized void notify(List<Long> oldValue, List<Long> newValue) {
        if (this.parent == null) {
            return;
        }
        if (oldValue.equals(newValue)) {
            return;
        }
        ((ElementImpl)this.parent).giNotify(this.feature, oldValue, newValue);
    }

    protected synchronized void validateElementToAdd(IElement element) {
        if (element == null) {
            return;
        }
        IbeeResource resource = this.parent.giGetResource();
        if (resource == null) {
            throw new RuntimeException("element '" + this.parent.giGetElementType().getName() + "' is not in a resource");
        }
        if (element.giGetResource() != null && element.giGetResource() != resource) {
            throw new RuntimeException("element '" + element.giGetElementType().getName() + "' is contained in a different resource");
        }
        if (element.giGetResource() == null && !this.feature.isContainment()) {
            throw new RuntimeException("element '" + element.giGetElementType().getName() + "' is not contained in a resource");
        }
        if (this.parent.isProtected(this.getFeature())) {
            throw new LockedElementException(this.parent);
        }
    }

    protected synchronized void addElementToResource(IElement element) {
        if (this.feature.isContainment()) {
            IElement currentParent = element.giGetParent();
            if (currentParent != null && currentParent != this.parent) {
                throw new RuntimeException("element " + element.giGetElementType().getName() + " has already another parent");
            }
            if (element.giGetResource() == null) {
                IbeeResource resource = this.parent.giGetResource();
                resource.putObject(element);
            }
        }
    }

    @Override
    public synchronized IListFeature<T> getFeature() {
        return this.feature;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            List<T> itIds;
            Iterator<T> internalIterator;
            {
                this.itIds = ListHandleImpl.this.getElements();
                this.internalIterator = this.itIds.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.internalIterator.hasNext();
            }

            @Override
            public T next() {
                return (IElement)this.internalIterator.next();
            }
        };
    }

    @Override
    public boolean remove(Object arg0) {
        this.removeElement((IElement)arg0);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int cnt = 0;
        IbeeResource model = this.parent.giGetResource();
        if (model == null) {
            return cnt;
        }
        for (long id : this.ids) {
            IElement element = model.getObject(id);
            if (element == null) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public Object[] toArray() {
        return this.getElements().toArray();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof IElement) {
            Long id = ((IElement)o).giGetElementId();
            return this.ids.contains(id);
        }
        return false;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getElements().toArray(a);
    }

    @Override
    public boolean add(T e) {
        this.addElement(e);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getElements().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.addElements(c);
        return true;
    }

    @Override
    public void clear() {
        this.clearElements();
    }
}

