/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IProxy;
import net.edgemind.ibee.core.library.IbeeLibraryEntry;
import net.edgemind.ibee.core.library.LibraryListener;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceModificationListener;

public class IbeeLibrary {
    private IbeeResource resource;
    private Map<String, IbeeLibraryEntry> sMap = new HashMap<String, IbeeLibraryEntry>();
    private boolean modified;
    private Map<String, Object> data = new HashMap<String, Object>();
    List<LibraryListener> libraryListeners;
    ResourceModificationListener resourceListener;
    private IProxy proxy;
    private String ilbName;

    public void reset() {
        this.sMap.clear();
    }

    public IProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(IProxy proxy) {
        this.proxy = proxy;
        if (this.resource != null) {
            this.resource.setProxy(proxy);
        }
    }

    public void reset(String sid) {
        IbeeLibraryEntry entry = this.sMap.get(sid = this.cleanSid(sid));
        if (entry != null) {
            entry.clear();
        }
        this.sMap.remove(sid);
    }

    public void setName(String libName) {
        this.ilbName = libName;
    }

    public String getName() {
        return this.ilbName;
    }

    public Set<String> getIdentifiers() {
        return this.sMap.keySet();
    }

    public synchronized Collection<IElement> getObjects(String sid) {
        IbeeLibraryEntry entry = this.getEntry(sid);
        if (entry != null) {
            return entry.getAllObjects();
        }
        return null;
    }

    public void putObject(String sid, IElement element, boolean isRoot) {
        IbeeLibraryEntry entry = this.getEntry(sid = this.cleanSid(sid));
        if (entry == null) {
            entry = new IbeeLibraryEntry();
            entry.setSid(sid);
            this.sMap.put(sid, entry);
        }
        entry.putObject(element);
        if (isRoot) {
            entry.setRoot(element);
        }
    }

    public IElement getRoot(String sid) {
        IbeeLibraryEntry entry = this.getEntry(sid);
        if (entry != null) {
            return entry.getRoot();
        }
        return null;
    }

    public boolean contains(String sid) {
        sid = this.cleanSid(sid);
        return this.sMap.containsKey(sid);
    }

    public IbeeLibraryEntry getEntry(String sid) {
        sid = this.cleanSid(sid);
        return this.getEntry(sid, false);
    }

    public IbeeLibraryEntry getEntry(String sid, boolean create) {
        IbeeLibraryEntry entry = this.sMap.get(sid = this.cleanSid(sid));
        if (entry == null && create) {
            entry = new IbeeLibraryEntry();
            this.sMap.put(sid, entry);
        }
        return entry;
    }

    public synchronized List<IElement> purge(String sid) {
        IbeeLibraryEntry entry = this.getEntry(sid);
        if (entry != null) {
            return entry.purge();
        }
        return Collections.emptyList();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean value) {
        this.modified = value;
    }

    public void setData(String key, Object value) {
        this.data.put(key, value);
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    private String cleanSid(String sid) {
        int index = sid.indexOf(":");
        if (index >= 0) {
            sid = sid.substring(index + 1);
        }
        return sid;
    }

    public void setResource(IbeeResource resource) {
        if (this.resource != null && this.resourceListener != null) {
            this.resource.removeModificationListener(this.resourceListener);
        }
        this.resource = resource;
        this.resource.setProxy(this.proxy);
        if (this.resourceListener == null) {
            this.resourceListener = this.createResourceListener();
        }
        if (resource != null) {
            resource.addModificationListener(this.resourceListener);
        }
    }

    private ResourceModificationListener createResourceListener() {
        return new ResourceModificationListener(){

            @Override
            public void removed(IElement element) {
                if (IbeeLibrary.this.libraryListeners != null) {
                    for (LibraryListener l : IbeeLibrary.this.libraryListeners) {
                        l.removed(IbeeLibrary.this, element);
                    }
                }
            }

            @Override
            public void modified(IElement element, IFeature feature, Object oldValue, Object newValue) {
                if (IbeeLibrary.this.libraryListeners != null) {
                    for (LibraryListener l : IbeeLibrary.this.libraryListeners) {
                        l.modified(IbeeLibrary.this, element, feature, oldValue, newValue);
                    }
                }
            }

            @Override
            public void added(IElement element) {
                if (IbeeLibrary.this.libraryListeners != null) {
                    for (LibraryListener l : IbeeLibrary.this.libraryListeners) {
                        l.added(IbeeLibrary.this, element);
                    }
                }
            }
        };
    }

    public IbeeResource getResource() {
        return this.resource;
    }

    public void addLibraryListener(LibraryListener listener) {
        if (this.libraryListeners == null) {
            this.libraryListeners = new ArrayList<LibraryListener>();
        }
        this.libraryListeners.add(listener);
    }

    public void removeLibraryListener(LibraryListener listener) {
        if (this.libraryListeners == null) {
            return;
        }
        this.libraryListeners.remove(listener);
    }
}

