/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogEntry;
import net.edgemind.ibee.core.log.LogLevel;

public abstract class ALogHandler
implements ILogHandler {
    public LogLevel logLevel = LogLevel.INFO;
    private String name;

    public ALogHandler() {
        this("");
    }

    public ALogHandler(String name) {
        this.name = name;
    }

    public ALogHandler(String name, LogLevel logLevel) {
        this.name = name;
        this.logLevel = logLevel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ALogHandler setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public void log(String msg) {
        this.log(msg, LogLevel.INFO);
    }

    public ALogHandler setLogLevel(LogLevel level) {
        this.logLevel = level;
        return this;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void log(Throwable e) {
        this.log(e, LogLevel.ERROR);
    }

    @Override
    public void log(Throwable e, LogLevel logLevel) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(stream);
        e.printStackTrace(printStream);
        printStream.close();
        this.log(stream.toString(), logLevel);
    }

    @Override
    public void log(LogEntry entry) {
        this.log(entry.getMessage(), entry.getLevel());
    }
}

