/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.log;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.edgemind.ibee.core.log.ALogHandler;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogLevel;

public class LogDispatcher
extends ALogHandler
implements ILogHandler,
Closeable,
Flushable {
    private List<ILogHandler> logHandlerList = new ArrayList<ILogHandler>();

    public LogDispatcher(ILogHandler ... logHandler) {
        Arrays.asList(logHandler).forEach(this::append);
    }

    public LogDispatcher append(ILogHandler logHandler) {
        if (logHandler == null) {
            return this;
        }
        this.logHandlerList.add(logHandler);
        return this;
    }

    public LogDispatcher remove(ILogHandler logHandler) {
        this.logHandlerList.remove(logHandler);
        return this;
    }

    @Override
    public void log(String msg, LogLevel level) {
        for (ILogHandler handler : this.logHandlerList) {
            handler.log(msg, level);
        }
    }

    @Override
    public void log(Throwable e) {
        for (ILogHandler handler : this.logHandlerList) {
            handler.log(e);
        }
    }

    @Override
    public LogLevel getLogLevel() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void close() throws IOException {
        for (ILogHandler handler : this.logHandlerList) {
            if (!(handler instanceof Closeable)) continue;
            ((Closeable)((Object)handler)).close();
        }
    }

    @Override
    public void flush() throws IOException {
        for (ILogHandler handler : this.logHandlerList) {
            if (!(handler instanceof Flushable)) continue;
            ((Flushable)((Object)handler)).flush();
        }
    }
}

