/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.log;

import net.edgemind.ibee.core.context.ContextStack;
import net.edgemind.ibee.core.exception.ManualInteruptionException;
import net.edgemind.ibee.core.log.ALogable;
import net.edgemind.ibee.core.log.ILogable;
import net.edgemind.ibee.core.monitor.IMonitorable;
import net.edgemind.ibee.util.exec.IRunnableWithExceptionT;
import net.edgemind.ibee.util.string.StringUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class LogableAndMonitored
extends ALogable
implements IMonitorable,
ILogable {
    private IProgressMonitor monitor;

    @Override
    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public IProgressMonitor getMonitor() {
        IProgressMonitor monitor = this.monitor;
        if (monitor == null) {
            monitor = ContextStack.getCurrentContextValue(IProgressMonitor.class);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    public boolean isCancelled() {
        IProgressMonitor monitor = this.getMonitor();
        if (monitor != null) {
            return monitor.isCanceled();
        }
        return false;
    }

    public void cancelWork() {
        IProgressMonitor monitor = this.getMonitor();
        if (monitor != null) {
            monitor.setCanceled(true);
        }
    }

    public void progress(int work) {
        IProgressMonitor monitor = this.getMonitor();
        if (monitor != null) {
            monitor.worked(work);
        }
    }

    public <T extends Exception> void executeWorkWithException(String name, int totalWork, IRunnableWithExceptionT<T> work) throws T {
        try {
            this.beginWork(name, totalWork);
            work.run();
        }
        finally {
            this.done();
        }
    }

    public void executeWork(String name, int totalWork, Runnable work) {
        this.executeWork(name, totalWork, work, 0);
    }

    public void executeWork(String name, int totalWork, Runnable work, int worked) {
        try {
            this.beginWork(name, totalWork);
            work.run();
        }
        finally {
            this.done();
            this.worked(worked);
        }
    }

    public void beginWork(String name, int totalWork) {
        IProgressMonitor monitor = this.getMonitor();
        if (monitor != null) {
            monitor.beginTask(name, totalWork);
        }
        if (!StringUtil.isNullOrEmpty((String)name)) {
            this.log("Execute " + name);
        }
    }

    public void setWorkName(String name) {
        IProgressMonitor monitor = this.getMonitor();
        if (monitor != null) {
            monitor.setTaskName(name);
        }
        if (!StringUtil.isNullOrEmpty((String)name)) {
            this.log("Execute " + name);
        }
    }

    public void addStep(String stepName, Runnable run, int worked) {
        this.subWork(stepName);
        run.run();
        this.worked(worked);
    }

    public void addStep(String stepName) {
        this.subWork(stepName);
    }

    public void subWork(String name) {
        IProgressMonitor monitor = this.getMonitor();
        if (monitor != null) {
            monitor.subTask(name);
        }
        if (!StringUtil.isNullOrEmpty((String)name)) {
            this.log("Execute " + name);
        }
    }

    public void done() {
        IProgressMonitor monitor = this.getMonitor();
        if (monitor != null) {
            monitor.done();
        }
    }

    public void worked(int work) {
        IProgressMonitor monitor = this.getMonitor();
        if (monitor != null) {
            monitor.worked(work);
        }
    }

    public void interruptIfCancelled() {
        if (this.isCancelled()) {
            this.interrupt();
        }
    }

    public void interrupt() {
        throw new ManualInteruptionException();
    }
}

