/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.property;

import java.util.Arrays;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IEnumType;
import net.edgemind.ibee.core.iml.domain.IType;
import net.edgemind.ibee.core.iml.domain.types.IntegerType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.property.IProvidesChoices;
import net.edgemind.ibee.core.property.StringPropertyIMF;
import net.edgemind.ibee.util.string.StringUtil;

public class AttrPropertyIMF
extends StringPropertyIMF
implements IProvidesChoices {
    private IAttributeFeature attr;
    private Object[] enums;
    private String[] enumsLabels;

    public AttrPropertyIMF(String name, IAttributeFeature attr) {
        super(name);
        this.attr = attr;
        if (attr != null) {
            super.setDefaultValue(attr.getDefaultValue());
            super.setDescription(attr.getDescription());
            super.setUnit(attr.getUnit());
            if (attr.getType() instanceof IEnumType) {
                IEnumType enumType = (IEnumType)attr.getType();
                this.enums = new Object[enumType.getEnums().size()];
                enumType.getEnums().toArray(this.enums);
                this.enumsLabels = new String[this.enums.length];
                int i = 0;
                while (i < this.enums.length) {
                    this.enumsLabels[i] = this.enums[i].toString();
                    ++i;
                }
            }
        }
    }

    public IAttributeFeature getAttr(IElementType<?> type) {
        return this.attr;
    }

    public AttrPropertyIMF setUnit(String unit) {
        super.setUnit(unit);
        return this;
    }

    public AttrPropertyIMF(String name, IAttributeFeature attr, String[] enums) {
        super(name);
        this.attr = attr;
        this.enums = enums;
        this.enumsLabels = new String[enums.length];
        int i = 0;
        while (i < enums.length) {
            this.enumsLabels[i] = enums[i].toUpperCase();
            ++i;
        }
    }

    public AttrPropertyIMF(String name, IAttributeFeature attr, Object[] enums) {
        super(name);
        this.attr = attr;
        this.enums = new String[enums.length];
        this.enumsLabels = new String[enums.length];
        int i = 0;
        while (i < enums.length) {
            this.enums[i] = enums[i].toString().toLowerCase();
            this.enumsLabels[i] = enums[i].toString().toUpperCase();
            ++i;
        }
    }

    public AttrPropertyIMF(String name, IAttributeFeature attr, Object[] enums, String[] enumsLabels) {
        super(name);
        this.attr = attr;
        this.enums = new String[enums.length];
        this.enumsLabels = new String[enums.length];
        int i = 0;
        while (i < enums.length) {
            this.enums[i] = enums[i].toString();
            this.enumsLabels[i] = enumsLabels[i].toString();
            ++i;
        }
    }

    public void setAttr(IAttributeFeature attr) {
        this.attr = attr;
    }

    @Override
    public boolean isRequired() {
        if (this.attr != null) {
            if (this.attr.getDefaultValue() != null && !this.attr.getDefaultValue().isEmpty()) {
                return false;
            }
            return this.attr.isRequired();
        }
        return super.isRequired();
    }

    @Override
    public Object getEditValue(IElement element) {
        String value = element.giGetAttribute(this.getAttr(element.giGetElementType())).trim();
        if (this.enums != null) {
            int index = 0;
            while (index < this.enums.length) {
                String next = this.enums[index].toString();
                if (next.equalsIgnoreCase(value)) {
                    return index;
                }
                ++index;
            }
            return 0;
        }
        return value;
    }

    @Override
    public String getValue(IElement element) {
        IAttributeFeature attr = this.getAttr(element.giGetElementType());
        String value = element.giGetAttribute(attr).trim();
        if (this.enums != null) {
            int index = 0;
            while (index < this.enums.length) {
                String next = this.enums[index].toString();
                if (next.equalsIgnoreCase(value)) {
                    value = this.enumsLabels[index];
                    break;
                }
                ++index;
            }
        }
        return value;
    }

    @Override
    public boolean setEditValue(IElement element, Object value) {
        Object newValue = null;
        if (this.enums != null && value instanceof Integer) {
            int index = (Integer)value;
            newValue = index >= 0 && index < this.enums.length ? this.enums[index] : "";
        }
        if (value instanceof String) {
            Double d;
            String currentValue = this.getValue(element);
            if (currentValue.equals(value)) {
                return false;
            }
            newValue = (String)value;
            if (this.attr != null && this.attr.getType() == IntegerType.instance && (d = StringUtil.toDouble((String)((String)newValue), null)) != null && d == (double)d.intValue()) {
                newValue = StringUtil.toString((Integer)d.intValue());
            }
        }
        if (newValue != null) {
            element.giSetAttribute(this.getAttr(element.giGetElementType()), newValue.toString());
        }
        return newValue != null;
    }

    @Override
    public boolean editAble() {
        return true;
    }

    @Override
    public String checkEditValue(IElement element, Object editValue) {
        if (this.isEmpty(editValue)) {
            if (this.isRequired()) {
                return this.checkEmpty(editValue);
            }
            return null;
        }
        String error = null;
        if (editValue instanceof String) {
            IType<?> type;
            String strValue = (String)editValue;
            IAttributeFeature attr = this.getAttr(element.giGetElementType());
            if (attr != null && !(type = attr.getType()).isTypeValue(strValue)) {
                return "Invalid Type Value";
            }
        }
        return error;
    }

    @Override
    public String checkValue(IElement element) {
        return null;
    }

    public boolean isEnumBased() {
        return this.enums != null;
    }

    @Override
    public String[] getChoiceLabels() {
        if (this.enumsLabels == null) {
            return null;
        }
        return Arrays.copyOf(this.enumsLabels, this.enumsLabels.length);
    }

    @Override
    public Object[] getChoices() {
        if (this.enums == null) {
            return null;
        }
        return Arrays.copyOf(this.enums, this.enums.length);
    }
}

