/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.property;

import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.property.StringPropertyIMF;

public class ChildAttrPropertyIMF
extends StringPropertyIMF {
    IElementFeature<?> childType;
    private IAttributeFeature childAttr;

    public void setChildType(IElementFeature<?> childType) {
        this.childType = childType;
    }

    public ChildAttrPropertyIMF(String name, IElementFeature<?> child, IAttributeFeature childAttr) {
        super(name);
        this.childAttr = childAttr;
        this.childType = child;
    }

    public IAttributeFeature getChildAttr() {
        return this.childAttr;
    }

    public void setChildAttr(IAttributeFeature childAttr) {
        this.childAttr = childAttr;
    }

    public IElementFeature<?> getChildType() {
        return this.childType;
    }

    @Override
    public Object getEditValue(IElement element) {
        return this.getValue(element);
    }

    @Override
    public String checkEditValue(IElement element, Object editValue) {
        String error = null;
        if (this.isEmpty(editValue)) {
            if (this.isRequired()) {
                return this.checkEmpty(editValue);
            }
            return null;
        }
        if (editValue instanceof String) {
            IType<?> type;
            String strValue = (String)editValue;
            IAttributeFeature attr = this.childAttr;
            if (attr != null && !(type = attr.getType()).isTypeValue(strValue)) {
                return "Invalid Value Type";
            }
        }
        return error;
    }

    @Override
    public boolean setEditValue(IElement element, Object value) {
        Object child = element.giGetElement(this.childType).getElement();
        if (child == null) {
            return false;
        }
        if (child.giGetAttribute(this.childAttr).equals(value)) {
            return false;
        }
        child.giSetAttribute(this.childAttr, (String)value);
        return true;
    }

    @Override
    public String getValue(IElement element) {
        if (element == null) {
            return "";
        }
        Object child = element.giGetElement(this.childType).getElement();
        if (child == null) {
            return "";
        }
        return child.giGetAttribute(this.childAttr);
    }

    @Override
    public String checkValue(IElement element) {
        return null;
    }

    @Override
    public boolean isRequired() {
        if (this.childType != null) {
            if (this.childType.isAutoCreate() || this.childType.isRequired()) {
                if (this.childAttr.getDefaultValue() != null && !this.childAttr.getDefaultValue().isEmpty()) {
                    return false;
                }
                return this.childAttr.isRequired();
            }
            return this.childType.isRequired();
        }
        return super.isRequired();
    }
}

