/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.property;

import java.time.format.DateTimeFormatter;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.types.DateType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.property.AttrPropertyIMF;

public class DatePropertyIMF
extends AttrPropertyIMF {
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

    public DatePropertyIMF(String name, IAttributeFeature attr) {
        super(name, attr);
    }

    public DatePropertyIMF(String name, IAttributeFeature attr, String dateTimePattern) {
        super(name, attr);
        this.dateFormatter = DateTimeFormatter.ofPattern(dateTimePattern);
    }

    public DatePropertyIMF(String name, IAttributeFeature attr, DateTimeFormatter dateTimeFormatter) {
        super(name, attr);
        this.dateFormatter = dateTimeFormatter;
    }

    @Override
    public Object getEditValue(IElement element) {
        String value = element.giGetAttribute(this.getAttr(element.giGetElementType())).trim();
        return value;
    }

    @Override
    public String getValue(IElement element) {
        IAttributeFeature attr = this.getAttr(element.giGetElementType());
        String value = element.giGetAttribute(attr).trim();
        if (value.isBlank()) {
            return value;
        }
        return this.dateFormatter.format(DateType.dateFormat.parse(value));
    }

    @Override
    public boolean setEditValue(IElement element, Object value) {
        IAttributeFeature attr = this.getAttr(element.giGetElementType());
        String newValue = null;
        if (value instanceof String) {
            String currentValue = this.getValue(element);
            if (currentValue.equals(value)) {
                return false;
            }
            newValue = (String)value;
            if (attr != null && attr.getType() == DateType.instance) {
                newValue = DateType.dateFormat.format(this.dateFormatter.parse(newValue));
            }
        }
        if (newValue != null) {
            element.giSetAttribute(this.getAttr(element.giGetElementType()), newValue);
        }
        return newValue != null;
    }
}

