/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.property;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.property.ElementPropertyIMF;

public class RelExprAttributePropertyIMF
extends ElementPropertyIMF<String> {
    private Function<IElement, List<String>> resolver;
    private String delimiter = DEFAULT_DELIMITER;
    private boolean required = false;

    public Function<IElement, List<String>> getResolver() {
        return this.resolver;
    }

    public void setResolver(Function<IElement, List<String>> resolver) {
        this.resolver = resolver;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public RelExprAttributePropertyIMF(String name) {
        super(name);
        this.setEditAble(false);
    }

    @Override
    public String getValue(IElement element) {
        List<String> resolvedList = this.resolver.apply(element);
        String rooms = resolvedList.size() > 0 ? resolvedList.stream().collect(Collectors.joining(this.getDelimiter())) : "<NONE>";
        return String.format("%s", rooms);
    }

    @Override
    public String checkValue(IElement element) {
        return null;
    }

    @Override
    public int compareTo(String v1, String v2) {
        return v1.compareTo(v2);
    }

    @Override
    public Object getEditValue(IElement element) {
        return null;
    }

    @Override
    public String checkEditValue(IElement element, Object value) {
        if (this.isEmpty(value)) {
            if (this.isRequired()) {
                return this.checkEmpty(value);
            }
            return null;
        }
        return null;
    }

    @Override
    protected boolean isEmpty(Object o) {
        if (super.isEmpty(o)) {
            return true;
        }
        return o.equals("<NONE>");
    }

    @Override
    public boolean setEditValue(IElement element, Object value) {
        return false;
    }

    @Override
    public String toString(String value) {
        return value;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

