/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.property;

import java.text.DecimalFormat;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.property.AttrPropertyIMF;

public class ScientificNumberPropertyIMF
extends AttrPropertyIMF {
    public ScientificNumberPropertyIMF(String name, IAttributeFeature attr) {
        super(name, attr);
    }

    @Override
    public String getValue(IElement element) {
        String value = super.getValue(element);
        if (value == null || value.isBlank()) {
            return "";
        }
        try {
            float floatValue = Float.parseFloat(value);
            if ((double)floatValue < 1.0) {
                DecimalFormat df = new DecimalFormat("0.#####E0");
                return df.format(floatValue);
            }
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            return "parsing error";
        }
    }
}

