/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.resource.GlobalKey;
import net.edgemind.ibee.core.resource.KeyFeatureValueGetter;

public class GlobalKeyCreator {
    private Map<IFeature, String> replacements;

    public <T extends IElement> GlobalKey<T> createGlobalKey(T e) {
        IElementType<? extends IElement> type = e.giGetElementType();
        GlobalKey<? extends IElement> key = new GlobalKey<IElement>(type);
        List<IFeature> keyFeatures = type.getKeyFeatures();
        if (keyFeatures.isEmpty()) {
            return key;
        }
        KeyFeatureValueGetter valueGetter = new KeyFeatureValueGetter();
        for (IFeature keyFeature : keyFeatures) {
            String replacement = this.getReplacement(keyFeature);
            String value = replacement != null ? replacement : valueGetter.getFeatureValue(keyFeature, e);
            key.put(GlobalKeyCreator.getKey(keyFeature), value, false);
        }
        return key;
    }

    private static String getKey(IFeature feature) {
        return GlobalKeyCreator.getKey(feature.getName());
    }

    private static String getKey(String feature) {
        return feature.toLowerCase();
    }

    private String getReplacement(IFeature feature) {
        if (this.replacements == null) {
            return null;
        }
        return this.replacements.get(feature);
    }

    public Map<IFeature, String> getReplacements() {
        return this.replacements;
    }

    public void addReplacement(IFeature feature, String replacement) {
        if (this.replacements == null) {
            this.replacements = new HashMap<IFeature, String>();
        }
        this.replacements.put(feature, replacement);
    }
}

