/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.util.string.StringUtil;

public class KeyFeatureValueGetter {
    private StringBuffer buf = new StringBuffer();

    public String getHash(IElement e) {
        this.buf = new StringBuffer();
        this.getFeatureValue(e);
        return this.buf.toString();
    }

    public String getFeatureValue(IFeature feature, IElement e) {
        if (feature instanceof IAttributeFeature) {
            return this.getAttrFeatureValue((IAttributeFeature)feature, e);
        }
        if (feature instanceof IListFeature) {
            return this.getListFeatureValue((IListFeature)feature, e);
        }
        if (feature instanceof IElementFeature) {
            return this.getElementFeatureValue((IElementFeature)feature, e);
        }
        return "";
    }

    public String getAttrFeatureValue(IAttributeFeature feature, IElement e) {
        this.buf = new StringBuffer();
        this.getFeatureValue(e, feature);
        return this.buf.toString();
    }

    public String getListFeatureValue(IListFeature<? extends IElement> feature, IElement e) {
        this.buf = new StringBuffer();
        this.getFeatureValue(e, feature);
        return this.buf.toString();
    }

    public String getElementFeatureValue(IElementFeature<? extends IElement> feature, IElement e) {
        this.buf = new StringBuffer();
        this.getFeatureValue(e, feature);
        return this.buf.toString();
    }

    private void getFeatureValue(IElement e, IAttributeFeature feature) {
        String value = e.giGetAttribute(feature);
        if (feature.isCaseInSensitive()) {
            value = value.toLowerCase();
        }
        this.buf.append(value);
    }

    private void getFeatureValue(IElement e, IListFeature<? extends IElement> feature) {
        if (feature.isOrdered()) {
            for (IElement iElement : e.giGetList(feature).getElements()) {
                this.getFeatureValue(iElement);
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (IElement iElement : e.giGetList(feature).getElements()) {
                KeyFeatureValueGetter getter = new KeyFeatureValueGetter();
                String hash = getter.getHash(iElement);
                arrayList.add(hash);
            }
            List list = StringUtil.performStringSort(arrayList);
            list.forEach(this.buf::append);
        }
    }

    private void getFeatureValue(IElement e, IElementFeature<? extends IElement> feature) {
        if (!e.giGetElement(feature).isSet()) {
            return;
        }
        IElement child = e.giGetElement(feature).getElement();
        if (child != null) {
            this.getFeatureValue(child);
        }
    }

    private void getFeatureValue(IElement e) {
        this.openTag(e.giGetElementType().getName());
        for (IAttributeFeature iAttributeFeature : e.giGetElementType().getAttributeFeatures()) {
            if (!iAttributeFeature.isKey()) continue;
            this.openTag(iAttributeFeature.getName());
            this.getFeatureValue(e, iAttributeFeature);
            this.closeTag(iAttributeFeature.getName());
        }
        for (IElementFeature iElementFeature : e.giGetElementType().getElementFeatures()) {
            if (!iElementFeature.isKey()) continue;
            this.openTag(iElementFeature.getName());
            this.getFeatureValue(e, iElementFeature);
            this.closeTag(iElementFeature.getName());
        }
        for (IListFeature iListFeature : e.giGetElementType().getListFeatures()) {
            if (!iListFeature.isKey()) continue;
            this.openTag(iListFeature.getName());
            this.getFeatureValue(e, iListFeature);
            this.closeTag(iListFeature.getName());
        }
        this.closeTag(e.giGetElementType().getName());
    }

    private void openTag(String tag) {
        this.buf.append("<");
        this.buf.append(tag);
        this.buf.append(">");
    }

    private void closeTag(String tag) {
        this.buf.append("</");
        this.buf.append(tag);
        this.buf.append(">");
    }
}

