/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ElementImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.library.IbeeLibraryEntry;
import net.edgemind.ibee.core.resource.IElementMapper;
import net.edgemind.ibee.core.resource.IFeatureFilter;
import net.edgemind.ibee.core.resource.IbeeResource;

public class ResourceImporter {
    private IbeeResource resource;
    private Map<Long, Long> importMap = new HashMap<Long, Long>();
    private IElementMapper elementMapper = null;

    public ResourceImporter(IbeeResource resource) {
        this.resource = resource;
    }

    public void setElementMapper(IElementMapper mapper) {
        this.elementMapper = mapper;
    }

    public void reset() {
        this.importMap.clear();
    }

    public synchronized IElement importFromLibrary(IbeeLibrary library, String sid) {
        return this.importFromLibrary(library, sid, null);
    }

    public synchronized IElement importFromLibrary(IbeeLibrary library, String sid, IElement target) {
        this.importMap.clear();
        IbeeLibraryEntry entry = library.getEntry(sid);
        if (entry != null) {
            Long rootid;
            if (entry.getRoot() != null && target != null) {
                this.importMap.put(entry.getRoot().giGetElementId(), target.giGetElementId());
            }
            Map<Long, Long> map = this.replicateElements(entry.getAllObjects(), null);
            if (entry.getRoot() != null && (rootid = map.get(entry.getRoot().giGetElementId())) != null && rootid >= 0L) {
                IElement rootE = this.resource.getObject(rootid);
                return rootE;
            }
        }
        return null;
    }

    public synchronized <T extends IElement> T importElement(T element) {
        return this.importElement(element, null);
    }

    public synchronized <T extends IElement> T importElement(T element, T target) {
        return this.importElement(element, target, null);
    }

    public synchronized <T extends IElement> T importElement(T element, T target, IFeatureFilter filter) {
        this.importMap.clear();
        if (target != null) {
            this.importMap.put(element.giGetElementId(), target.giGetElementId());
        }
        ArrayList<IElement> allElements = new ArrayList<IElement>();
        this.collectChildren(element, allElements, filter);
        Map<Long, Long> map = this.replicateElements(allElements, filter);
        return (T)this.resource.getObject(map.get(element.giGetElementId()));
    }

    public synchronized IElement importElements(Collection<IElement> elements) {
        return this.importElements(elements, null);
    }

    public synchronized IElement importElements(Collection<IElement> elements, IFeatureFilter filter) {
        this.importMap.clear();
        ArrayList<IElement> elementsWithChildren = new ArrayList<IElement>();
        for (IElement e : elements) {
            this.collectChildren(e, elementsWithChildren, filter);
        }
        this.replicateElements(elementsWithChildren, filter);
        return null;
    }

    public void collectChildren(IElement e, Collection<IElement> result, IFeatureFilter filter) {
        result.add(e);
        for (IListFeature<IElement> iListFeature : e.giGetElementType().getListFeatures()) {
            if (filter != null && !filter.accept(iListFeature) || !iListFeature.isContainment()) continue;
            for (IElement iElement : e.giGetList(iListFeature).getElements()) {
                this.collectChildren(iElement, result, filter);
            }
        }
        for (IElementFeature iElementFeature : e.giGetElementType().getElementFeatures()) {
            Object t;
            if (filter != null && !filter.accept(iElementFeature) || !iElementFeature.isContainment() || (t = e.giGetElement(iElementFeature).getElement()) == null) continue;
            this.collectChildren((IElement)t, result, filter);
        }
    }

    private Long getMappedChild(Long id, IbeeResource target) {
        IElement mappedChild;
        IElement child;
        Long importedChildId = this.importMap.get(id);
        if (this.elementMapper != null && importedChildId == null && (child = target.getObject(id)) != null && (mappedChild = this.elementMapper.map(child, this.resource)) != null) {
            importedChildId = mappedChild.giGetElementId();
            this.importMap.put(id, importedChildId);
        }
        return importedChildId;
    }

    public synchronized Map<Long, Long> replicateElements(Collection<IElement> elements, IFeatureFilter filter) {
        for (IElement element : elements) {
            IElement clone;
            Long importedId = this.getMappedChild(element.giGetElementId(), element.giGetResource());
            if (importedId == null) {
                clone = element.giGetElementType().getDomain().create(element.giGetElementType());
                this.resource.putObject(clone);
                this.importMap.put(element.giGetElementId(), clone.giGetElementId());
                continue;
            }
            clone = this.resource.getObject(importedId);
            this.clearFiltered(clone, filter);
        }
        Iterator<IElement> iterator = elements.iterator();
        while (iterator.hasNext()) {
            IElement element;
            IElement elementToImport = element = iterator.next();
            Long importedId = this.importMap.get(elementToImport.giGetElementId());
            IElement clone = this.resource.getObject(importedId);
            for (IAttributeFeature iAttributeFeature : elementToImport.giGetElementType().getAttributeFeatures()) {
                if (filter != null && !filter.accept(iAttributeFeature)) continue;
                String value = elementToImport.giGetAttribute(iAttributeFeature);
                clone.giSetAttribute(iAttributeFeature, value);
            }
            for (IListFeature iListFeature : elementToImport.giGetElementType().getListFeatures()) {
                if (filter != null && !filter.accept(iListFeature)) continue;
                ArrayList<Long> ids = new ArrayList<Long>();
                for (Long childId : ((ListHandleImpl)elementToImport.giGetList(iListFeature)).getAllElementIds()) {
                    IElement importedChild;
                    Long importedChildId = this.getMappedChild(childId, elementToImport.giGetResource());
                    if (importedChildId == null) continue;
                    ids.add(importedChildId);
                    if (!iListFeature.isContainment() || (importedChild = this.resource.getObject(importedChildId)) == null) continue;
                    ((ElementImpl)importedChild).giSetParentId(importedId, iListFeature);
                }
                if (ids.size() <= 0) continue;
                ((ListHandleImpl)clone.giGetList(iListFeature)).setAllElementsByIdInject(ids, false);
            }
            for (IElementFeature iElementFeature : elementToImport.giGetElementType().getElementFeatures()) {
                IElement importedChild;
                Long importedChildId;
                Long childId;
                if (filter != null && !filter.accept(iElementFeature) || (childId = Long.valueOf(((ElementHandleImpl)elementToImport.giGetElement(iElementFeature)).getElementId())) == null || childId < 0L || (importedChildId = this.getMappedChild(childId, elementToImport.giGetResource())) == null) continue;
                ((ElementHandleImpl)clone.giGetElement(iElementFeature)).setElementByIdInject(importedChildId, false);
                if (!iElementFeature.isContainment() || (importedChild = this.resource.getObject(importedChildId)) == null) continue;
                ((ElementImpl)importedChild).giSetParentId(importedId, iElementFeature);
            }
        }
        return this.importMap;
    }

    private void clearFiltered(IElement element, IFeatureFilter filter) {
        for (IAttributeFeature iAttributeFeature : element.giGetElementType().getAttributeFeatures()) {
            if (filter != null && !filter.accept(iAttributeFeature)) continue;
            element.giSetAttribute(iAttributeFeature, null);
        }
        for (IListFeature iListFeature : element.giGetElementType().getListFeatures()) {
            if (filter != null && !filter.accept(iListFeature)) continue;
            element.giGetList(iListFeature).clearElements();
        }
        for (IElementFeature iElementFeature : element.giGetElementType().getElementFeatures()) {
            if (filter != null && !filter.accept(iElementFeature)) continue;
            element.giGetElement(iElementFeature).setElement(null);
        }
    }

    public Map<Long, Long> getImportMap() {
        return this.importMap;
    }
}

