/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jsinterop.annotations.JsType;
import net.edgemind.ibee.core.iml.domain.IBasicReferenceType;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.ImfComponentType;
import net.edgemind.ibee.core.iml.domain.ImfReferenceType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.ImfComponent;
import net.edgemind.ibee.core.iml.model.ImfIdComponent;
import net.edgemind.ibee.core.iml.model.ImfNamedComponent;
import net.edgemind.ibee.core.iml.model.ImfNamedElement;
import net.edgemind.ibee.core.iml.model.ImfReference;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.resource.GlobalHashResource;
import net.edgemind.ibee.core.resource.GlobalKey;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.impl.HashStorage;
import net.edgemind.ibee.core.resource.impl.IbeeResourceImpl;
import net.edgemind.ibee.core.util.Selection;
import net.edgemind.ibee.util.misc.IFilter;

@JsType(namespace="ibee")
public class GlobalHashIbeeResourceImpl
extends IbeeResourceImpl
implements GlobalHashResource {
    private static String globalKeyString = "__global-key";
    private static String namedKeyString = "__named-key";
    private static String idKeyString = "__id-key";
    private HashStorage<IElementType<?>, GlobalKey<?>, IElement> storage = new HashStorage();
    private IFilter<IElement> hashedElementsFilter = e -> (e.isComponent() || e.isGlobal() || e.isReference()) && this.hasKeyFeatures((IElement)e);
    private IbeeResource parent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyElementDeletion(IElement element) {
        HashStorage<IElementType<?>, GlobalKey<?>, IElement> hashStorage = this.storage;
        synchronized (hashStorage) {
            if (this.hashedElementsFilter.accept((Object)element)) {
                this.removeKey(globalKeyString, element);
                this.removeKey(namedKeyString, element);
                this.removeKey(idKeyString, element);
            }
        }
        super.notifyElementDeletion(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyElementCreation(IElement element) {
        HashStorage<IElementType<?>, GlobalKey<?>, IElement> hashStorage = this.storage;
        synchronized (hashStorage) {
            this.storeElement(element);
        }
        super.notifyElementCreation(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(IElement element, IFeature feature, Object oldValue, Object newValue) {
        IElement origElement = element;
        IFeature origFeature = feature;
        HashStorage<IElementType<?>, GlobalKey<?>, IElement> hashStorage = this.storage;
        synchronized (hashStorage) {
            while (element != null && feature != null) {
                if (feature.isKey() && this.hashedElementsFilter.accept((Object)element)) {
                    this.storeElement(element);
                }
                if (element.isComponent() || element.isGlobal()) break;
                feature = element.giGetParentFeature();
                element = element.giGetParent();
            }
        }
        super.notify(origElement, origFeature, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IElement> T resolve(GlobalKey<T> globalKey) {
        IElementType<T> type = globalKey.getType();
        IElement el = null;
        HashStorage<IElementType<?>, GlobalKey<?>, IElement> hashStorage = this.storage;
        synchronized (hashStorage) {
            el = this.storage.getFirst(type, globalKey);
        }
        if (el != null && !this.defines(el, true)) {
            el = null;
        }
        if (el == null) {
            for (IbeeLibrary lib : this.getLibraries()) {
                IbeeResource res = lib.getResource();
                if (res == null) continue;
                el = res.resolve(globalKey);
            }
        }
        return (T)el;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void repairStorage() {
        super.repairStorage();
        this.storage.clear();
        HashStorage<IElementType<?>, GlobalKey<?>, IElement> hashStorage = this.storage;
        synchronized (hashStorage) {
            for (IElement element : this.getAllObjects()) {
                this.storeElement(element);
            }
        }
    }

    private void storeElement(IElement element) {
        if (this.hashedElementsFilter.accept((Object)element)) {
            this.removeKey(globalKeyString, element);
            GlobalKey<IElement> globalKey = this.createKey(element);
            if (!globalKey.isEmpty()) {
                this.storage.add(element.giGetElementType(), globalKey, element);
                element.setData(globalKeyString, globalKey);
            }
        }
        if (element instanceof ImfNamedComponent && !this.isUniqueByName(element.giGetElementType())) {
            this.removeKey(namedKeyString, element);
            ImfNamedComponent namedComponent = (ImfNamedComponent)element;
            GlobalKey namedKey = this.createNamedKey((ImfComponentType)namedComponent.giGetElementType(), namedComponent.getName());
            if (!namedKey.isEmpty()) {
                this.storage.add(element.giGetElementType(), namedKey, element);
                element.setData(namedKeyString, namedKey);
            }
        }
        if (element instanceof ImfIdComponent && !this.isUniqueById(element.giGetElementType())) {
            this.removeKey(idKeyString, element);
            ImfIdComponent idComponent = (ImfIdComponent)element;
            GlobalKey idKey = this.createIdKey((ImfComponentType)idComponent.giGetElementType(), idComponent.getId());
            if (!idComponent.isEmpty()) {
                this.storage.add(element.giGetElementType(), idKey, element);
                element.setData(idKeyString, idKey);
            }
        }
    }

    private void removeKey(String keyString, IElement element) {
        GlobalKey key = (GlobalKey)element.getData(keyString);
        if (key != null) {
            this.storage.remove(element.giGetElementType(), key, element);
            element.setData(keyString, null);
        }
    }

    private boolean hasKeyFeatures(IElement el) {
        return !el.giGetElementType().getKeyFeatures().isEmpty();
    }

    private boolean isUniqueByName(IElementType<?> type) {
        if (type instanceof ImfComponentType && type.isNamed()) {
            return type.getKeyFeatures().size() == 1 && type.getKeyFeatures().get(0) == ImfNamedComponent.nameFeature;
        }
        return false;
    }

    private boolean isUniqueById(IElementType<?> type) {
        if (type instanceof ImfIdComponent) {
            return type.getKeyFeatures().size() == 1 && type.getKeyFeatures().get(0) == ImfIdComponent.idFeature;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IElement> Collection<T> getGlobalElements(GlobalKey<T> globalKey, boolean withInherited, boolean withLibs) {
        Collection<T> set = new HashSet<IElement>();
        IElementType<T> type = globalKey.getType();
        HashStorage<IElementType<?>, GlobalKey<?>, IElement> hashStorage = this.storage;
        synchronized (hashStorage) {
            set.addAll(this.storage.getElements(type, globalKey));
        }
        if (withInherited) {
            for (IElementType<T> iElementType : this.storage.getKeys1()) {
                if (!iElementType.inherits(type)) continue;
                set.addAll(this.storage.getElements(iElementType, globalKey));
            }
        }
        set = set.stream().filter(e -> this.defines((IElement)e, true)).collect(Collectors.toSet());
        if (withLibs) {
            for (IbeeLibrary ibeeLibrary : this.getLibraries()) {
                IbeeResource res = ibeeLibrary.getResource();
                if (res == null) continue;
                set.addAll(((GlobalHashResource)res).getGlobalElements(globalKey, withInherited, false));
            }
        }
        return set;
    }

    @Override
    public <T extends IElement> Collection<T> getGlobalElements(IElementType<T> type, boolean withLibs, boolean withInherited, IFilter<T> filter) {
        HashSet<IElement> set = new HashSet<IElement>();
        if (withInherited) {
            for (IElementType<T> iElementType : this.storage.getKeys1()) {
                if (!iElementType.inherits(type)) continue;
                set.addAll(this.storage.getElements(iElementType));
            }
        } else {
            set.addAll(this.storage.getElements(type));
        }
        if (withLibs) {
            this.doForAllLibs(lib -> {
                boolean bl2 = set.addAll(lib.getGlobalElements(type, false, withInherited, filter));
            });
        }
        IFilter iFilter = el -> this.defines((IElement)el, true) && (filter == null || filter.accept(el));
        return set.stream().filter(e -> finalFilter.accept(e)).collect(Collectors.toSet());
    }

    private void doForAllResources(Consumer<IbeeResource> resourceConsumer, boolean withLibs) {
        resourceConsumer.accept(this);
        if (withLibs) {
            this.doForAllLibs(resourceConsumer);
        }
    }

    private void doForAllLibs(Consumer<IbeeResource> resourceConsumer) {
        for (IbeeLibrary lib : this.getLibraries()) {
            IbeeResource res = lib.getResource();
            if (res == null) continue;
            resourceConsumer.accept(res);
        }
    }

    private <T extends IElement> GlobalKey<T> createKey(T element) {
        GlobalKey<T> key = GlobalKey.createFrom(element);
        return key;
    }

    private <T extends ImfNamedComponent> GlobalKey<T> createNamedKey(ImfComponentType<T> componentType, String componentName) {
        GlobalKey<T> key = GlobalKey.createFrom(componentType);
        String value = componentName;
        if (ImfNamedElement.nameFeature.isCaseInSensitive()) {
            value = value.toLowerCase();
        }
        key.put(ImfNamedElement.nameFeature, componentName);
        return key;
    }

    private <T extends ImfIdComponent> GlobalKey<T> createIdKey(ImfComponentType<T> componentType, Long componentId) {
        GlobalKey<T> key = GlobalKey.createFrom(componentType);
        String value = String.valueOf(componentId);
        key.put(ImfIdComponent.idFeature, value);
        return key;
    }

    @Override
    public Collection<ImfReference> getReferences(ImfComponent component) {
        IDomain domain = component.giGetResource().getDomain();
        HashSet<ImfReferenceType> relevantRefTypes = new HashSet<ImfReferenceType>();
        for (IElementType<?> type : domain.getTypes()) {
            if (type.isAbstract() || !type.isReferenceType()) continue;
            ImfReferenceType refType = (ImfReferenceType)type;
            if (refType.getTargetTypes().size() == 0) {
                relevantRefTypes.add(refType);
                continue;
            }
            for (IElementType<?> referencedType : refType.getTargetTypes()) {
                if (!component.giGetElementType().inherits(referencedType)) continue;
                relevantRefTypes.add(refType);
            }
        }
        HashSet<ImfReference> references = new HashSet<ImfReference>();
        GlobalKey<ImfComponent> targetKey = GlobalKey.createFrom(component);
        for (ImfReferenceType refType : relevantRefTypes) {
            if (refType instanceof IBasicReferenceType) {
                GlobalKey refKey = new GlobalKey(refType);
                refKey.importData(targetKey);
                references.addAll(this.storage.getElements(refType, refKey));
                continue;
            }
            for (IElement refEl : this.storage.getElements(refType)) {
                ImfReference ref = (ImfReference)refEl;
                if (ref.resolve() != component) continue;
                references.add(ref);
            }
        }
        return references;
    }

    @Override
    public <T extends ImfNamedComponent> Selection<T> getComponents(ImfComponentType<T> componentType, String componentName) {
        return this.getComponents(componentType, componentName, false);
    }

    @Override
    public <T extends ImfNamedComponent> Selection<T> getComponents(ImfComponentType<T> componentType, String componentName, boolean withLibs) {
        GlobalKey<T> namedKey = this.createNamedKey(componentType, componentName);
        return new Selection<T>(this.getGlobalElements(namedKey, false, withLibs));
    }

    @Override
    public <T extends ImfComponent> Selection<T> getComponentsByType(ImfComponentType<T> componentType) {
        return this.getComponentsByType(componentType, false);
    }

    @Override
    public <T extends ImfComponent> Selection<T> getComponentsByType(ImfComponentType<T> componentType, boolean withLibs) {
        Selection<IElement> set = new Selection<IElement>(this.storage.getElements(componentType));
        if (withLibs) {
            this.doForAllLibs(lib -> set.addAll(lib.getComponentsByType(componentType, withLibs)));
        }
        return set;
    }

    @Override
    public <T extends ImfNamedComponent> Selection<T> getComponentsByName(String componentName) {
        return this.getComponentsByName(componentName, false);
    }

    @Override
    public <T extends ImfIdComponent> T getComponentById(ImfComponentType<T> componentType, Long componentId) {
        if (componentType.isIdBased()) {
            GlobalKey<T> idKey = this.createIdKey(componentType, componentId);
            Selection<T> sel = new Selection<T>(this.getGlobalElements(idKey, false, false));
            return (T)((ImfIdComponent)sel.first());
        }
        return null;
    }

    @Override
    public <T extends ImfNamedComponent> Selection<T> getComponentsByName(String componentName, boolean withLibs) {
        Selection set = new Selection();
        for (IElementType<?> type : this.storage.getKeys1()) {
            if (!type.isNamed() || !type.isComponentType()) continue;
            GlobalKey<T> namedKey = this.createNamedKey((ImfComponentType)type, componentName);
            set.addAll(this.getGlobalElements(namedKey, false, false));
        }
        if (withLibs) {
            this.doForAllLibs(lib -> set.addAll(lib.getComponentsByName(componentName, withLibs)));
        }
        return set;
    }

    public void printStorage() {
        System.out.println("Stored Elements:");
        for (IElementType key : this.storage.content.keySet()) {
            Map map = this.storage.content.get(key);
            System.out.println(String.format("-Type : %s:", key.getName()));
            for (GlobalKey key2 : map.keySet()) {
                System.out.println(String.format("--Entry %s: (%d elements)", key2.getData().toString(), map.get(key2).size()));
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.storage.clear();
    }

    @Override
    public IbeeResource getMainResource() {
        if (this.parent == null) {
            return this;
        }
        return this.parent;
    }

    @Override
    public void setParent(IbeeResource resource) {
        this.parent = resource;
    }
}

