/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import jsinterop.annotations.JsIgnore;
import net.edgemind.ibee.core.context.Context;
import net.edgemind.ibee.core.context.IContext;
import net.edgemind.ibee.core.iml.ImfModelException;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.domain.ImfComponentType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IProxy;
import net.edgemind.ibee.core.iml.model.ImfIdComponent;
import net.edgemind.ibee.core.iml.model.impl.DefaultProxy;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ElementImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.library.LibraryListener;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.GlobalKey;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.LibraryDescriptor;
import net.edgemind.ibee.core.resource.ResourceDirtyListener;
import net.edgemind.ibee.core.resource.ResourceFactory;
import net.edgemind.ibee.core.resource.ResourceLibraryListener;
import net.edgemind.ibee.core.resource.ResourceModificationListener;
import net.edgemind.ibee.core.resource.edit.EditingDomain;
import net.edgemind.ibee.core.resource.impl.ResourceImpl;
import net.edgemind.ibee.core.resource.type.IResourceType;
import net.edgemind.ibee.core.resource.type.IbeeResourceType;
import net.edgemind.ibee.core.resource.url.URL;
import net.edgemind.ibee.util.misc.IFilter;

public abstract class IbeeResourceImpl
extends ResourceImpl
implements IbeeResource {
    private long rootId = -1L;
    private int notificationsEnabledCnt = 0;
    private IContext defaultContext = new Context();
    private Supplier<IContext> contextProvider = () -> this.defaultContext;
    private Map<String, Object> data = new HashMap<String, Object>();
    private boolean isRootResource = true;
    private long sessionId = 0L;
    private EditingDomain editingDomain;
    private IProxy proxy;
    private List<ResourceModificationListener> modificationListeners = new ArrayList<ResourceModificationListener>();
    private List<ResourceDirtyListener> dirtyListeners = new ArrayList<ResourceDirtyListener>();
    private List<ResourceLibraryListener> libraryListeners = new ArrayList<ResourceLibraryListener>();
    private long nextElementId = 0L;
    private Map<IElementType<?>, Long> nextComponentId = new HashMap();
    private int namespaceId = 0;
    private boolean dirty;
    private Map<Long, IElement> elementMap = new HashMap<Long, IElement>();
    private List<LibraryDescriptor> libraries = new ArrayList<LibraryDescriptor>();
    private Map<LibraryDescriptor, LibraryListener> registeredListeners = new HashMap<LibraryDescriptor, LibraryListener>();
    private boolean alwaysNotifyKeyChanges = true;

    @Override
    public boolean getAlwaysNotifyKeyChanges() {
        return this.alwaysNotifyKeyChanges;
    }

    @Override
    public void setAlwaysNotifyKeyChanges(boolean value) {
        this.alwaysNotifyKeyChanges = value;
    }

    public static IbeeResource create() {
        return ResourceFactory.getInstance().createIbeeResource();
    }

    public IbeeResourceImpl(URL url) {
        super(url);
        this.sessionId = new Date().getTime();
    }

    @JsIgnore
    public IbeeResourceImpl() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNamespaceId(int namespaceId) {
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            if (this.namespaceId == namespaceId) {
                return;
            }
            this.namespaceId = namespaceId;
            this.nextElementId = this.namespaceId;
            this.nextElementId <<= 32;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinId(int minId) {
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            int currentMin = (int)this.nextElementId;
            if (minId > currentMin) {
                LogUtil.log("update min Id from " + currentMin + " to " + minId, LogLevel.DEBUG);
                this.nextElementId = this.namespaceId;
                this.nextElementId <<= 32;
                this.nextElementId += (long)minId;
            }
        }
    }

    @Override
    public <T extends IElement> T create(IElementType<T> type) {
        T e = type.getDomain().create(type);
        this.putObject((IElement)e);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextElementId() {
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            ++this.nextElementId;
            while (this.elementMap.containsKey(this.nextElementId)) {
                ++this.nextElementId;
            }
            return this.nextElementId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextComponentId(ImfComponentType<? extends ImfIdComponent> componentType) {
        Map<IElementType<?>, Long> map = this.nextComponentId;
        synchronized (map) {
            Long nextComponentId = this.nextComponentId.get(componentType);
            if (nextComponentId == null) {
                nextComponentId = 0L;
            }
            nextComponentId = nextComponentId + 1L;
            while (this.getComponentById(componentType, nextComponentId) != null) {
                nextComponentId = nextComponentId + 1L;
            }
            this.nextComponentId.put(componentType, nextComponentId);
            return nextComponentId;
        }
    }

    @Override
    public void testSetComponentId(ImfIdComponent component, Long componentId) {
        if (componentId == null) {
            return;
        }
        IElementType componentType = component.giGetElementType();
        Object existing = this.getComponentById(componentType, componentId);
        if (existing != null && existing != null && existing != component) {
            throw new ImfModelException(String.format("%s with ID '%d' exists already.", componentType.getName(), componentId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IElement getObject(long id) {
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            IElement e = this.elementMap.get(id);
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putObject(IElement element) {
        if (element == null) {
            return;
        }
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            if (element.giGetElementId() == -1L) {
                long elementId = this.getNextElementId();
                ((ElementImpl)element).giSetId(elementId);
                ((ElementImpl)element).setSyncId(this.getVersion());
            } else {
                long elementId = element.giGetElementId();
                IElement existing = this.elementMap.get(elementId);
                if (existing == element) {
                    return;
                }
                if (existing != null) {
                    throw new ImfModelException("put object failed: Resource cantains already an object with id " + elementId);
                }
                if (elementId > this.nextElementId) {
                    this.nextElementId = elementId;
                }
            }
            ((ElementImpl)element).giSetResource(this);
            this.elementMap.put(element.giGetElementId(), element);
        }
        if (element instanceof ImfIdComponent) {
            this.autoSetComponentId((ImfIdComponent)element);
        }
        if (this.notificationsEnabled() || this.alwaysNotifyKeyChanges) {
            this.notifyElementCreation(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoSetComponentId(ImfIdComponent component) {
        if (component == null) {
            return;
        }
        Map<IElementType<?>, Long> map = this.nextComponentId;
        synchronized (map) {
            if (component.getId() == null || component.getId() == -1L) {
                long componentId = this.getNextComponentId((ImfComponentType<? extends ImfIdComponent>)component.giGetElementType());
                component.setId(componentId);
            } else {
                long componentId = component.getId();
                IElementType componentType = component.giGetElementType();
                Object existing = this.getComponentById(componentType, componentId);
                if (existing == component) {
                    return;
                }
                if (existing != null) {
                    throw new ImfModelException(String.format("put object failed: Resource cantains already a %s component with id %d ", component.giGetElementType().getName(), componentId));
                }
                Long maxComponentId = this.nextComponentId.get(componentType);
                if (maxComponentId == null) {
                    maxComponentId = 0L;
                }
                if (componentId > maxComponentId) {
                    this.nextComponentId.put(componentType, componentId);
                }
                component.setId(componentId);
            }
        }
    }

    @Override
    @JsIgnore
    public void putObjects(IElement[] elements) {
        IElement[] iElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IElement e = iElementArray[n2];
            this.putObject(e);
            ++n2;
        }
    }

    @Override
    public void putObjects(Collection<IElement> elements) {
        for (IElement e : elements) {
            this.putObject(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllObjects() {
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            this.elementMap.clear();
            this.rootId = -1L;
        }
    }

    @Override
    public synchronized EditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.editingDomain = new EditingDomain();
        }
        return this.editingDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModificationListener(ResourceModificationListener listener) {
        List<ResourceModificationListener> list = this.modificationListeners;
        synchronized (list) {
            this.modificationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(IElement element, IFeature feature, Object oldValue, Object newValue) {
        if (this.notificationsEnabled()) {
            ArrayList<ResourceModificationListener> copy;
            this.setDirty(true);
            List<ResourceModificationListener> list = this.modificationListeners;
            synchronized (list) {
                copy = new ArrayList<ResourceModificationListener>(this.modificationListeners);
            }
            for (ResourceModificationListener listener : copy) {
                listener.modified(element, feature, oldValue, newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyElementCreation(IElement element) {
        if (this.notificationsEnabled()) {
            ArrayList<ResourceModificationListener> copy;
            this.setDirty(true);
            List<ResourceModificationListener> list = this.modificationListeners;
            synchronized (list) {
                copy = new ArrayList<ResourceModificationListener>(this.modificationListeners);
            }
            for (ResourceModificationListener listener : copy) {
                listener.added(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyElementDeletion(IElement element) {
        if (this.notificationsEnabled()) {
            ArrayList<ResourceModificationListener> copy;
            this.setDirty(true);
            List<ResourceModificationListener> list = this.modificationListeners;
            synchronized (list) {
                copy = new ArrayList<ResourceModificationListener>(this.modificationListeners);
            }
            for (ResourceModificationListener listener : copy) {
                listener.removed(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModificationListener(ResourceModificationListener listener) {
        List<ResourceModificationListener> list = this.modificationListeners;
        synchronized (list) {
            this.modificationListeners.remove(listener);
        }
    }

    @Override
    public IElement getRoot() {
        return this.getObject(this.rootId);
    }

    @Override
    public void setRoot(IElement root) {
        if (root == null) {
            this.rootId = -1L;
            return;
        }
        this.putObject(root);
        this.rootId = root.giGetElementId();
    }

    @Override
    public IElementType<?> getRootType() {
        IElement root = this.getRoot();
        if (root != null) {
            return root.giGetElementType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IElement> purge() {
        ArrayList<IElement> copy;
        LogUtil.log("purge resource", LogLevel.DEBUG);
        if (this.rootId == -1L) {
            return null;
        }
        IElement rootElement = this.getObject(this.rootId);
        if (rootElement == null) {
            return null;
        }
        Set<IElement> keep = this.getContainedElements(rootElement);
        ArrayList<IElement> toPurge = new ArrayList<IElement>();
        for (IElement element : this.elementMap.values()) {
            if (keep.contains(element)) continue;
            toPurge.add(element);
        }
        for (IElement element : toPurge) {
            Map<Long, IElement> map = this.elementMap;
            synchronized (map) {
                this.elementMap.remove(element.giGetElementId());
            }
            if (!this.notificationsEnabled() && !this.alwaysNotifyKeyChanges) continue;
            this.notifyElementDeletion(element);
        }
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            copy = new ArrayList<IElement>(this.elementMap.values());
        }
        for (IElement element : copy) {
            for (IListFeature<IElement> iListFeature : element.giGetElementType().getListFeatures()) {
                boolean modified = false;
                List<Long> ids = ((ListHandleImpl)element.giGetList(iListFeature)).getAllElementIds();
                ArrayList<Long> newIds = null;
                for (Long id : ids) {
                    if (this.elementMap.containsKey(id)) {
                        if (newIds == null) {
                            newIds = new ArrayList<Long>();
                        }
                        newIds.add(id);
                        continue;
                    }
                    modified = true;
                }
                if (!modified) continue;
                ((ElementImpl)element).giNotify(iListFeature, ids, newIds);
            }
            for (IElementFeature iElementFeature : element.giGetElementType().getElementFeatures()) {
                Long id = ((ElementHandleImpl)element.giGetElement(iElementFeature)).getElementId();
                if (id == -1L || this.elementMap.containsKey(id)) continue;
                ((ElementImpl)element).giNotify(iElementFeature, id, -1L);
            }
        }
        return toPurge;
    }

    @Override
    public void remove(IElement element, boolean recursive) {
        if (!element.isRemoved()) {
            element.remove();
        }
        if (recursive) {
            Set<IElement> containedElements = this.getContainedElements(element);
            for (IElement next : containedElements) {
                this.notifyElementRemoval(next);
            }
        } else {
            this.notifyElementRemoval(element);
        }
    }

    private void notifyElementRemoval(IElement element) {
        if (this.notificationsEnabled() || this.alwaysNotifyKeyChanges) {
            this.notifyElementDeletion(element);
        }
    }

    public Set<IElement> getContainedElements(IElement element) {
        HashSet<IElement> set = new HashSet<IElement>(0);
        this.getContainedElements(element, set);
        return set;
    }

    private void getContainedElements(IElement element, Set<IElement> set) {
        if (element == null) {
            return;
        }
        if (set.contains(element)) {
            return;
        }
        if (element != null) {
            set.add(element);
            for (IElementFeature<?> iElementFeature : element.giGetElementType().getElementFeatures()) {
                if (!iElementFeature.isContainment()) continue;
                Object child = element.giGetElement(iElementFeature).getElement();
                this.getContainedElements((IElement)child, set);
            }
            for (IListFeature iListFeature : element.giGetElementType().getListFeatures()) {
                if (!iListFeature.isContainment()) continue;
                for (Object child : element.giGetList(iListFeature).getElements()) {
                    this.getContainedElements((IElement)child, set);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            return this.elementMap.keySet().size();
        }
    }

    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    @JsIgnore
    public boolean isRootResource() {
        return this.isRootResource;
    }

    public void isRootResource(boolean value) {
        this.isRootResource = value;
    }

    @Override
    public List<ResourceModificationListener> getModificationListener() {
        return this.modificationListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        Object object = this;
        synchronized (object) {
            this.modificationListeners.clear();
            this.dirtyListeners.clear();
            this.libraries.clear();
            this.libraryListeners.clear();
            this.data.clear();
            this.registeredListeners.clear();
        }
        object = this.elementMap;
        synchronized (object) {
            ArrayList<Long> ids = new ArrayList<Long>(this.elementMap.keySet());
            for (Long id : ids) {
                IElement element = this.elementMap.get(id);
                if (element == null) continue;
                element.remove();
            }
            this.elementMap.clear();
        }
    }

    @Override
    public void setContext(Supplier<IContext> contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void setContext(IContext context) {
        this.contextProvider = () -> context;
    }

    @Override
    public IContext getContext() {
        return this.contextProvider.get();
    }

    @Override
    public IResourceType getResourceType() {
        return IbeeResourceType.getInstance();
    }

    @Override
    public void reset() {
        super.reset();
        this.clearAllObjects();
        this.getEditingDomain().getCommandStack().clear();
    }

    @Override
    public boolean defines(IElement element, boolean strict) {
        if (element == null) {
            return false;
        }
        return !element.isRemoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String key, Object value) {
        Map<String, Object> map = this.data;
        synchronized (map) {
            this.data.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(String key) {
        Map<String, Object> map = this.data;
        synchronized (map) {
            return this.data.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IbeeLibrary> getLibraries() {
        ArrayList<IbeeLibrary> list = new ArrayList<IbeeLibrary>();
        List<LibraryDescriptor> list2 = this.libraries;
        synchronized (list2) {
            for (LibraryDescriptor desc : this.libraries) {
                list.add(desc.getLibrary());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LibraryDescriptor addLibrary(IbeeLibrary library, String url, int index) {
        LibraryDescriptor desc = new LibraryDescriptor();
        List<LibraryDescriptor> list = this.libraries;
        synchronized (list) {
            if (index < 0) {
                index = this.libraries.size();
            }
            if (url == null) {
                url = library.getName();
            }
            desc.setLibrary(library);
            library.setProxy(this.getProxy());
            desc.setUrl(url);
            this.libraries.add(index, desc);
            LibraryListener l = this.createLibraryListener(desc);
            this.registeredListeners.put(desc, l);
            library.addLibraryListener(l);
        }
        for (ResourceLibraryListener l : this.libraryListeners) {
            l.libraryAdded(this, desc);
        }
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLibrary(IbeeLibrary library) {
        ArrayList<ResourceLibraryListener> copy;
        LibraryDescriptor removedLib = null;
        List<LibraryDescriptor> list = this.libraries;
        synchronized (list) {
            for (LibraryDescriptor desc : this.libraries) {
                LibraryListener reg;
                if (desc.getLibrary() != library) continue;
                this.libraries.remove(desc);
                if (this.registeredListeners != null && (reg = this.registeredListeners.get(desc)) != null) {
                    this.registeredListeners.remove(desc);
                }
                removedLib = desc;
                break;
            }
            copy = new ArrayList<ResourceLibraryListener>(this.libraryListeners);
        }
        if (removedLib != null) {
            for (ResourceLibraryListener l : copy) {
                l.libraryRemoved(this, removedLib);
            }
        }
    }

    private LibraryListener createLibraryListener(final LibraryDescriptor desc) {
        return new LibraryListener(){

            @Override
            public void libraryRenamed(IbeeLibrary library) {
                if (!IbeeResourceImpl.this.notificationsEnabled()) {
                    return;
                }
                for (ResourceLibraryListener l : IbeeResourceImpl.this.libraryListeners) {
                    l.libraryRenamed(desc);
                }
            }

            @Override
            public void modified(IbeeLibrary library, IElement element, IFeature feature, Object oldValue, Object newValue) {
                if (!IbeeResourceImpl.this.notificationsEnabled()) {
                    return;
                }
                for (ResourceLibraryListener listener : IbeeResourceImpl.this.libraryListeners) {
                    listener.modified(library, element, feature, oldValue, newValue);
                }
            }

            @Override
            public void added(IbeeLibrary library, IElement element) {
                if (!IbeeResourceImpl.this.notificationsEnabled()) {
                    return;
                }
                for (ResourceLibraryListener listener : IbeeResourceImpl.this.libraryListeners) {
                    listener.added(library, element);
                }
            }

            @Override
            public void removed(IbeeLibrary library, IElement element) {
                if (!IbeeResourceImpl.this.notificationsEnabled()) {
                    return;
                }
                for (ResourceLibraryListener listener : IbeeResourceImpl.this.libraryListeners) {
                    listener.removed(library, element);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IbeeLibrary getLibrary(String url) {
        List<LibraryDescriptor> list = this.libraries;
        synchronized (list) {
            for (LibraryDescriptor desc : this.libraries) {
                if (!desc.getUrl().equals(url)) continue;
                return desc.getLibrary();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LibraryDescriptor getDescriptor(IbeeLibrary library) {
        List<LibraryDescriptor> list = this.libraries;
        synchronized (list) {
            for (LibraryDescriptor desc : this.libraries) {
                if (desc.getLibrary() != library) continue;
                return desc;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IbeeLibrary getLibraryByName(String name) {
        List<LibraryDescriptor> list = this.libraries;
        synchronized (list) {
            for (LibraryDescriptor desc : this.libraries) {
                if (!desc.getLibrary().getName().equals(name)) continue;
                return desc.getLibrary();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IbeeLibrary getLibrary(IElement element) {
        if (element == null) {
            return null;
        }
        IbeeResource resource = element.giGetResource();
        if (element.giGetResource() == this) {
            return null;
        }
        List<LibraryDescriptor> list = this.libraries;
        synchronized (list) {
            for (LibraryDescriptor desc : this.libraries) {
                if (desc.getLibrary().getResource() != resource) continue;
                return desc.getLibrary();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLibraryListener(ResourceLibraryListener listener) {
        List<ResourceLibraryListener> list = this.libraryListeners;
        synchronized (list) {
            this.libraryListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLibraryListener(ResourceLibraryListener listener) {
        List<ResourceLibraryListener> list = this.libraryListeners;
        synchronized (list) {
            this.libraryListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLibraryIndex(IbeeLibrary library, int index) {
        LibraryDescriptor desc = this.getDescriptor(library);
        ArrayList<ResourceLibraryListener> copy = null;
        List<LibraryDescriptor> list = this.libraries;
        synchronized (list) {
            if (desc != null && index >= 0 && index < this.libraries.size()) {
                this.libraries.remove(desc);
                this.libraries.add(index, desc);
                copy = new ArrayList<ResourceLibraryListener>(this.libraryListeners);
            }
        }
        if (copy != null) {
            for (ResourceLibraryListener l : copy) {
                l.libraryOrderChanged(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLibraryIndex(IbeeLibrary library) {
        List<LibraryDescriptor> list = this.libraries;
        synchronized (list) {
            int i = 0;
            while (i < this.libraries.size()) {
                LibraryDescriptor desc = this.libraries.get(i);
                if (desc.getLibrary() == library) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDirty(boolean value) {
        ArrayList<ResourceDirtyListener> copy;
        IbeeResourceImpl ibeeResourceImpl = this;
        synchronized (ibeeResourceImpl) {
            if (this.dirty == value) {
                return;
            }
            this.dirty = value;
        }
        List<ResourceDirtyListener> list = this.dirtyListeners;
        synchronized (list) {
            copy = new ArrayList<ResourceDirtyListener>(this.dirtyListeners);
        }
        for (ResourceDirtyListener listener : copy) {
            listener.dirtyChanged(value, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirty() {
        IbeeResourceImpl ibeeResourceImpl = this;
        synchronized (ibeeResourceImpl) {
            return this.dirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean defines(IElement e) {
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            return this.elementMap.containsKey(e.giGetElementId());
        }
    }

    @Override
    public synchronized void disableNotifications() {
        ++this.notificationsEnabledCnt;
    }

    @Override
    public synchronized void enableNotifications() {
        if (this.notificationsEnabledCnt > 0) {
            --this.notificationsEnabledCnt;
            if (!this.getAlwaysNotifyKeyChanges() && this.notificationsEnabled()) {
                this.repairStorage();
            }
        }
    }

    protected void repairStorage() {
    }

    @Override
    public Collection<IElement> getAllObjects() {
        return this.getAllObjects(-1L);
    }

    @Override
    public Collection<IElement> getAllObjects(boolean onlyContained) {
        return this.getAllObjects(-1L, onlyContained);
    }

    @Override
    public Collection<IElement> getAllObjects(long lastSyncId) {
        return this.getAllObjects(lastSyncId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IElement> getAllObjects(long lastSyncId, boolean onlyContained) {
        ArrayList<IElement> copy;
        if (lastSyncId == this.getVersion()) {
            return new ArrayList<IElement>();
        }
        ArrayList<IElement> list = new ArrayList<IElement>();
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            copy = new ArrayList<IElement>(this.elementMap.values());
        }
        for (IElement next : copy) {
            if (lastSyncId != -1L && next.giGetSyncId() <= lastSyncId || onlyContained && !this.defines(next, true)) continue;
            list.add(next);
        }
        return list;
    }

    @Override
    @JsIgnore
    public <T extends IElement> List<T> getAllObjects(IElementType<T> type) {
        return this.getAllObjects(type, true);
    }

    @Override
    public <T extends IElement> List<T> getAllObjects(IElementType<T> type, boolean onlyContained) {
        return this.getAllObjects(type, onlyContained, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IElement> List<T> getAllObjects(IElementType<T> type, boolean onlyContained, boolean withInherited) {
        ArrayList<IElement> copy;
        ArrayList<IElement> result = new ArrayList<IElement>();
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            copy = new ArrayList<IElement>(this.elementMap.values());
        }
        for (IElement e : copy) {
            if (!e.giGetElementType().equals(type) && (!withInherited || !e.giGetElementType().inherits(type)) || onlyContained && !this.defines(e, true)) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public Collection<IElement> getAllObjects(IFilter<IElement> filter) {
        return this.getAllObjects(filter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IElement> getAllObjects(IFilter<IElement> filter, boolean onlyContained) {
        ArrayList<IElement> copy;
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            copy = new ArrayList<IElement>(this.elementMap.values());
        }
        ArrayList<IElement> list = new ArrayList<IElement>();
        for (IElement next : copy) {
            if (filter != null && !filter.accept((Object)next) || onlyContained && !this.defines(next, true)) continue;
            list.add(next);
        }
        return list;
    }

    @Override
    public Collection<IElement> getDependentObjects(IElement element) {
        ArrayList<IElement> list = new ArrayList<IElement>();
        this.collectObjects(element, list);
        return list;
    }

    private void collectObjects(IElement element, Collection<IElement> list) {
        if (element == null) {
            return;
        }
        if (list.contains(element)) {
            return;
        }
        if (element != null) {
            list.add(element);
            for (IElementFeature<?> iElementFeature : element.giGetElementType().getElementFeatures()) {
                Object child = element.giGetElement(iElementFeature).getElement();
                this.collectObjects((IElement)child, list);
            }
            for (IListFeature iListFeature : element.giGetElementType().getListFeatures()) {
                for (Object child : element.giGetList(iListFeature).getElements()) {
                    this.collectObjects((IElement)child, list);
                }
            }
        }
    }

    @Override
    public synchronized IProxy getProxy() {
        IDomain domain;
        if (this.proxy == null && (domain = this.getDomain()) != null) {
            this.setProxy(domain.createProxy(this));
        }
        return this.proxy != null ? this.proxy : new DefaultProxy();
    }

    @Override
    public synchronized void setProxy(IProxy proxy) {
        this.proxy = proxy;
        for (IbeeLibrary lib : this.getLibraries()) {
            lib.setProxy(proxy);
        }
    }

    @Override
    public synchronized boolean notificationsEnabled() {
        return this.notificationsEnabledCnt == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDirtyListener(ResourceDirtyListener listener) {
        List<ResourceDirtyListener> list = this.dirtyListeners;
        synchronized (list) {
            this.dirtyListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDirtyListener(ResourceDirtyListener listener) {
        List<ResourceDirtyListener> list = this.dirtyListeners;
        synchronized (list) {
            this.dirtyListeners.remove(listener);
        }
    }

    @Override
    public <T extends IElement> Collection<T> getGlobalElements(IElementType<T> type, boolean withLibs, boolean withInherited, IFilter<T> filter) {
        HashSet<IElement> set = new HashSet<IElement>();
        for (IElement e : this.getAllObjects()) {
            if (e == null) continue;
            if (withInherited) {
                if (!e.giGetElementType().inherits(type) || filter != null && !filter.accept((Object)e)) continue;
                set.add(e);
                continue;
            }
            if (e.giGetElementType() != type || filter != null && !filter.accept((Object)e)) continue;
            set.add(e);
        }
        if (withLibs) {
            for (IbeeLibrary lib : this.getLibraries()) {
                IbeeResource res = lib.getResource();
                if (res == null) continue;
                set.addAll(res.getGlobalElements(type, false, withInherited, filter));
            }
        }
        return set;
    }

    @Override
    public <T extends IElement> Collection<T> getGlobalElements(GlobalKey<T> globalKey, boolean withInherited, boolean withLibs) {
        HashSet<IElement> set = new HashSet<IElement>();
        for (IElement el : this.getAllObjects(globalKey.getType(), true, withInherited)) {
            if (!globalKey.matches(el)) continue;
            set.add(el);
        }
        if (withLibs) {
            for (IbeeLibrary lib : this.getLibraries()) {
                IbeeResource res = lib.getResource();
                if (res == null) continue;
                set.addAll(res.getGlobalElements(globalKey, withInherited, false));
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IElementType<? extends IElement>> getAllElementTypes() {
        HashSet<IElementType<? extends IElement>> types = new HashSet<IElementType<? extends IElement>>();
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            for (IElement e : this.elementMap.values()) {
                types.add(e.giGetElementType());
            }
        }
        return types;
    }

    @Override
    public IDomain getDomain() {
        IElement root = this.getRoot();
        if (root != null) {
            return root.giGetElementType().getDomain();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IElement findFirst(IFilter<IElement> filter) {
        ArrayList<IElement> copy;
        Map<Long, IElement> map = this.elementMap;
        synchronized (map) {
            copy = new ArrayList<IElement>(this.elementMap.values());
        }
        for (IElement next : copy) {
            if (filter != null && !filter.accept((Object)next) || !this.defines(next, true)) continue;
            return next;
        }
        return null;
    }
}

