/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.resource.ResourceController;
import net.edgemind.ibee.core.resource.ResourceDescriptor;
import net.edgemind.ibee.core.resource.ResourceException;
import net.edgemind.ibee.core.resource.ResourceListener;
import net.edgemind.ibee.core.resource.ResourceManager;
import net.edgemind.ibee.core.resource.impl.ResourceDescriptorImpl;
import net.edgemind.ibee.core.resource.type.FileResourceType;
import net.edgemind.ibee.core.resource.type.IbeeResourceType;
import net.edgemind.ibee.core.resource.url.URL;

public abstract class ResourceManagerImpl
implements ResourceManager {
    protected Map<String, ResourceController> controllers = new HashMap<String, ResourceController>();
    private List<ResourceListener> listeners;

    protected abstract ResourceController createController(ResourceDescriptor var1);

    protected String urlToString(URL url) {
        return url.getSid() + "/" + url.getPath();
    }

    public void addResourceListener(ResourceListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ResourceListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public boolean exists(URL url) {
        ResourceDescriptor test = this.getDescriptor(url);
        return test != null;
    }

    @Override
    public void removeResource(URL url) throws ResourceException {
        if (url == null) {
            throw new ResourceException("remove resource: url must not be null");
        }
        ResourceController controller = this.getController(url, false);
        if (controller != null) {
            controller.close();
        }
        String key = this.urlToString(url).toLowerCase();
        this.controllers.remove(key);
    }

    @Override
    public List<ResourceDescriptor> getOpenedResources() {
        ArrayList<ResourceDescriptor> result = new ArrayList<ResourceDescriptor>();
        for (ResourceController controller : this.controllers.values()) {
            if (controller.getResource(false) == null) continue;
            result.add(controller.getDescriptor());
        }
        return result;
    }

    public ResourceController getController(URL url, boolean create) {
        ResourceDescriptor descriptor;
        String key = this.urlToString(url).toLowerCase();
        if (this.controllers.containsKey(key)) {
            return this.controllers.get(key);
        }
        if (create && (descriptor = this.getDescriptor(url)) != null) {
            ResourceController controller = this.createController(descriptor);
            if (controller != null) {
                this.controllers.put(key, controller);
            }
            return controller;
        }
        return null;
    }

    public boolean isOpen(URL url) {
        ResourceController controller = this.getController(url, false);
        if (controller == null) {
            return false;
        }
        return controller.getResource(false) != null;
    }

    protected ResourceDescriptor determineDescriptorFromkUrl(URL url) {
        ResourceDescriptorImpl descriptor = null;
        if (url.getScheme().equals(FileResourceType.name)) {
            descriptor = new ResourceDescriptorImpl(url);
            descriptor.setType(FileResourceType.getInstance());
        }
        if (url.getScheme().equals("ibee")) {
            descriptor = new ResourceDescriptorImpl(url);
            descriptor.setType(IbeeResourceType.getInstance());
        }
        return descriptor;
    }

    @Override
    public ResourceController getController(URL url) {
        return this.getController(url, true);
    }

    @Override
    public boolean hasResource(URL url) {
        return this.getController(url, false) == null;
    }
}

