/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.edgemind.ibee.core.iml.domain.DomainRegistry;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.model.IContent;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ElementImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceException;
import net.edgemind.ibee.core.resource.reader.ParentCorrector;

public class BinaryIbeeResourceReaderSingleFile {
    public IbeeResource readModel(String resourceDir, IbeeResource resource) throws ResourceException {
        try {
            File file = new File(resourceDir + File.separator + "data.bin");
            FileInputStream in = new FileInputStream(file);
            long rootId = this.readLong(in);
            if (rootId == -1L) {
                LogUtil.log("no root id found for resource " + resourceDir);
                return resource;
            }
            long nrObjects = this.readLong(in);
            LogUtil.log("read binary resource '" + String.valueOf(resource.getURL()) + "': " + nrObjects + " objects");
            this.parseResource(resource, nrObjects, in);
            in.close();
            resource.setRoot(resource.getObject(rootId));
            ParentCorrector corrector = new ParentCorrector();
            corrector.correct(resource);
            return resource;
        }
        catch (IOException io) {
            throw new ResourceException(io);
        }
    }

    private void parseResource(IbeeResource resource, long nrObjects, FileInputStream in) throws IOException {
        int objectNr = 0;
        while ((long)objectNr < nrObjects) {
            String domainName = this.readString(in);
            IDomain domain = DomainRegistry.getDomain(domainName);
            if (domain == null) {
                LogUtil.error("ModelReader:parseElement:unkown domain '" + domainName + "'");
                return;
            }
            int typeIndex = this.readInt(in);
            IElementType<?> type = domain.getTypes().get(typeIndex);
            if (type == null) {
                LogUtil.error("ModelReader:parseElement:unkown type ");
                return;
            }
            Object element = domain.create(type);
            ((ElementImpl)element).giSetId(this.readLong(in));
            this.readLong(in);
            long nrFeatures = this.readLong(in);
            int featureNr = 0;
            while ((long)featureNr < nrFeatures) {
                IContent handle;
                IFeature feature;
                int index;
                int featureType = this.readInt(in);
                if (featureType == 1) {
                    index = this.readInt(in);
                    feature = type.getElementFeatures().get(index);
                    handle = (ElementHandleImpl)element.giGetElement(feature);
                    long refId = this.readLong(in);
                    ((ElementHandleImpl)handle).setElementByIdInject(refId, false);
                }
                if (featureType == 2) {
                    index = this.readInt(in);
                    feature = type.getListFeatures().get(index);
                    handle = (ListHandleImpl)element.giGetList(feature);
                    int cnt = this.readInt(in);
                    ArrayList<Long> refIds = new ArrayList<Long>();
                    int i = 0;
                    while (i < cnt) {
                        refIds.add(this.readLong(in));
                        ++i;
                    }
                    ((ListHandleImpl)handle).setAllElementsByIdInject(refIds, false);
                }
                if (featureType == 3) {
                    index = this.readInt(in);
                    if (index >= type.getAttributeFeatures().size()) {
                        throw new IOException("unknwon attribute " + index + " of element " + type.getName());
                    }
                    feature = type.getAttributeFeatures().get(index);
                    String value = this.readString(in);
                    element.giSetAttribute((IAttributeFeature)feature, value);
                }
                ++featureNr;
            }
            resource.putObject((IElement)element);
            ++objectNr;
        }
    }

    private String readString(InputStream in) throws IOException {
        int l = this.readInt(in);
        byte[] bytes = new byte[l];
        in.read(bytes);
        return new String(bytes);
    }

    private long readLong(InputStream in) throws IOException {
        long v = 0L;
        int i = 0;
        while (i < 8) {
            v <<= 8;
            v += (long)in.read();
            ++i;
        }
        return v;
    }

    private int readInt(InputStream in) throws IOException {
        int v = 0;
        int i = 0;
        while (i < 4) {
            v <<= 8;
            v += in.read();
            ++i;
        }
        return v;
    }
}

