/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.reader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.iml.domain.DomainRegistry;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ElementImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceException;
import net.edgemind.ibee.core.resource.reader.ParentCorrector;
import net.edgemind.ibee.util.string.StringUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlIbeeResourceReaderSingleFile {
    public IbeeResource readModel(String resourceDir, IbeeResource resource) throws ResourceException {
        Document document = null;
        try {
            try {
                String xmlFile = resourceDir + File.separator + "data.xml";
                document = XmlUtil.readXmlFile((String)xmlFile);
                this.parseContent(document, resource);
                long rootId = StringUtil.toLong((String)document.getDocumentElement().getAttribute("root"), (Long)-1L);
                if (rootId != -1L) {
                    resource.setRoot(resource.getObject(rootId));
                }
            }
            catch (IOException io) {
                throw new ResourceException(io);
            }
        }
        catch (Throwable throwable) {
            if (document != null) {
                XmlUtil.destroy(document);
            }
            throw throwable;
        }
        if (document != null) {
            XmlUtil.destroy((Document)document);
        }
        return resource;
    }

    public IbeeResource readModelFromContent(String content, IbeeResource resource) throws ResourceException {
        Document document = null;
        try {
            try {
                document = XmlUtil.readXmlFile((InputStream)new ByteArrayInputStream(content.getBytes()));
                this.parseContent(document, resource);
                long rootId = StringUtil.toLong((String)document.getDocumentElement().getAttribute("root"), (Long)-1L);
                if (rootId != -1L) {
                    resource.setRoot(resource.getObject(rootId));
                }
            }
            catch (IOException io) {
                throw new ResourceException(io);
            }
        }
        catch (Throwable throwable) {
            if (document != null) {
                XmlUtil.destroy(document);
            }
            throw throwable;
        }
        if (document != null) {
            XmlUtil.destroy((Document)document);
        }
        return resource;
    }

    private void parseContent(Document document, IbeeResource resource) throws IOException {
        List elements = XmlUtil.getChildren((Element)document.getDocumentElement());
        for (Element xmlElement : elements) {
            String domainName = xmlElement.getAttribute("domain");
            IDomain domain = DomainRegistry.getDomain(domainName);
            if (domain == null) {
                LogUtil.error("ModelReader:parseElement:unkown domain '" + domainName + "'");
                return;
            }
            String typeName = xmlElement.getAttribute("type");
            IElementType<?> type = domain.getType(typeName);
            if (type == null) {
                LogUtil.error("ModelReader:parseElement:unkown type '" + typeName + "'");
                return;
            }
            Object element = domain.create(type);
            String idString = xmlElement.getAttribute("id");
            if (idString != null && !idString.isEmpty()) {
                long id = StringUtil.toLong((String)idString, (Long)-1L);
                ((ElementImpl)element).giSetId(id);
            }
            resource.putObject((IElement)element);
            List xmlAttributes = XmlUtil.getChildrenByTagName((String)"attribute", (Element)xmlElement);
            for (Element xmlAttribute : xmlAttributes) {
                element.giSetAttribute(xmlAttribute.getAttribute("name"), xmlAttribute.getTextContent());
            }
            List xmlLists = XmlUtil.getChildrenByTagName((String)"list", (Element)xmlElement);
            for (Element xmlList : xmlLists) {
                String[] args;
                ListHandleImpl listHandle;
                String listName = XmlUtil.getAttribute((Element)xmlList, (String)"name", (boolean)false);
                String idSequence = XmlUtil.getAttribute((Element)xmlList, (String)"ids", (boolean)true);
                if (idSequence == null || idSequence.isEmpty() || (listHandle = (ListHandleImpl)element.giGetList(listName)) == null) continue;
                ArrayList<Long> ids = new ArrayList<Long>();
                String[] stringArray = args = idSequence.split(",");
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    long id = StringUtil.toLong((String)arg, (Long)-1L);
                    if (id != -1L) {
                        ids.add(id);
                    }
                    ++n2;
                }
                listHandle.setAllElementsByIdInject(ids, false);
            }
            List xmlChilds = XmlUtil.getChildrenByTagName((String)"element", (Element)xmlElement);
            for (Element xmlChild : xmlChilds) {
                ElementHandleImpl elementHandle;
                long id;
                String childName = XmlUtil.getAttribute((Element)xmlChild, (String)"name", (boolean)false);
                idString = XmlUtil.getAttribute((Element)xmlChild, (String)"id", (boolean)true);
                if (idString == null || idString.isEmpty() || (id = StringUtil.toLong((String)idString, (Long)-1L).longValue()) == -1L || (elementHandle = (ElementHandleImpl)element.giGetElement(childName)) == null) continue;
                elementHandle.setElementByIdInject(id, false);
            }
        }
        ParentCorrector corrector = new ParentCorrector();
        corrector.correct(resource);
    }
}

