/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.reader.sax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.UnsupportedVersionResourceException;
import net.edgemind.ibee.core.resource.reader.XmlReaderException;
import net.edgemind.ibee.util.file.FileUtil;

public class ImfVersionReader {
    public String getVersion(File file) throws XmlReaderException {
        Map<String, String> meta = this.getMetaData(file);
        String version = meta.get("domain-version");
        if (version == null) {
            version = "1.0";
        }
        return version;
    }

    public Map<String, String> getMetaData(InputStream stream) throws XmlReaderException {
        try {
            return this.readMetaData(stream);
        }
        catch (IOException | XMLStreamException | UnsupportedVersionResourceException e) {
            throw new XmlReaderException(e);
        }
    }

    public Map<String, String> getMetaData(File modelFile) throws XmlReaderException {
        InputStream xmlInput = null;
        try {
            xmlInput = this.createInputStream(modelFile);
            Map<String, String> map = this.readMetaData(xmlInput);
            return map;
        }
        catch (IOException | XMLStreamException | UnsupportedVersionResourceException e) {
            throw new XmlReaderException(e);
        }
        finally {
            if (xmlInput != null) {
                try {
                    xmlInput.close();
                }
                catch (IOException e) {
                    LogUtil.log(e);
                }
            }
        }
    }

    private Map<String, String> readMetaData(InputStream inputStream) throws UnsupportedVersionResourceException, IOException, XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(inputStream, "UTF-8");
        HashMap<String, String> map = new HashMap<String, String>();
        int level = 0;
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                StartElement xmlElement = xmlEvent.asStartElement();
                if (++level == 2 && xmlElement.getName().getLocalPart().equals("meta")) {
                    Iterator<Attribute> it = xmlElement.getAttributes();
                    while (it.hasNext()) {
                        Attribute attr = it.next();
                        map.put(attr.getName().getLocalPart(), attr.getValue());
                    }
                }
                if (level == 2 && xmlElement.getName().getLocalPart().equals("root")) break;
            }
            if (!xmlEvent.isEndElement()) continue;
            --level;
        }
        return map;
    }

    private InputStream createInputStream(File file) throws IOException {
        if (FileUtil.isZipFile((File)file)) {
            return FileUtil.openZippedInputStream((File)file, (String)"_model.xml");
        }
        return FileUtil.openInputStream((File)file);
    }
}

