/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.reader.sax;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import net.edgemind.ibee.core.exception.ManualInteruptionException;
import net.edgemind.ibee.core.iml.domain.DomainRegistry;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IElementHandle;
import net.edgemind.ibee.core.iml.model.IListHandle;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ElementImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.io.IUserIO;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.util.string.StringUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.SAXException;

public class StaxHandlerGeneric {
    private Stack<StackElement> objectStack = new Stack();
    private IbeeResource model;
    private int objectCountTotal;
    private IProgressMonitor monitor;
    private List<Long> currentListFeatureIds;
    private ILogHandler logHandler;
    private IUserIO userIo;
    private int objectCount;
    private int lastProgress;

    public StaxHandlerGeneric(IbeeResource model) {
        this.model = model;
    }

    public void setNrOfObjects(int count) {
        this.objectCountTotal = count;
        this.objectCount = 0;
        this.lastProgress = 0;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void setLogHandler(ILogHandler logHandler) {
        this.logHandler = logHandler;
    }

    public void setUserIo(IUserIO userIo) {
        this.userIo = userIo;
    }

    public void startElement(StartElement xml) throws SAXException {
        String tag;
        if (this.monitor != null) {
            ++this.objectCount;
            int progress = this.objectCount * 100 / this.objectCountTotal;
            int delta = progress - this.lastProgress;
            if (delta > 0) {
                this.monitor.worked(delta);
                this.lastProgress = progress;
                if (this.monitor.isCanceled()) {
                    throw new ManualInteruptionException("Reading procedure has been canceled");
                }
            }
        }
        if ((tag = xml.getName().getLocalPart()).equals("element")) {
            IElement element = this.createElement(xml);
            if (element != null) {
                if (this.objectStack.size() == 0) {
                    this.model.setRoot(element);
                } else {
                    StackElement parentElement = this.objectStack.peek();
                    IFeature feature = parentElement.feature;
                    if (feature instanceof IListFeature) {
                        if (((IListFeature)feature).isContainment()) {
                            parentElement.element.giGetList((IListFeature)feature).addElement(element);
                        }
                    } else if (feature instanceof IElementFeature && ((IElementFeature)feature).isContainment()) {
                        parentElement.element.giGetElement((IElementFeature)feature).setElement(element);
                    }
                }
                this.objectStack.push(new StackElement(element));
            }
        } else if (tag.equals("list")) {
            StackElement parentElement = this.objectStack.peek();
            String fName = this.getAttributeValue(xml, "name");
            parentElement.feature = parentElement.element.giGetElementType().getListFeature(fName);
        } else if (tag.equals("child")) {
            StackElement parentElement = this.objectStack.peek();
            String fName = this.getAttributeValue(xml, "name");
            parentElement.feature = parentElement.element.giGetElementType().getElementFeature(fName);
        } else if (tag.equals("attribute")) {
            StackElement parentElement = this.objectStack.peek();
            String fName = this.getAttributeValue(xml, "name");
            parentElement.feature = parentElement.element.giGetElementType().getAttributeFeature(fName);
        } else {
            StackElement parentElement = this.objectStack.peek();
            String ename = parentElement.element.giGetElementType().getName();
            throw new SAXException("Unexpected tag " + tag + " within element " + ename);
        }
    }

    private IElement createElement(StartElement el) {
        IElementType<?> type;
        String domainName = this.getAttributeValue(el, "domain");
        String typeName = this.getAttributeValue(el, "type");
        String id = this.getAttributeValue(el, "id");
        IDomain domain = DomainRegistry.getDomain(domainName);
        if (domain != null && (type = domain.getType(typeName)) != null) {
            Object element = domain.create(type);
            ((ElementImpl)element).giSetId(StringUtil.toLong((String)id, (Long)-1L));
            return element;
        }
        return null;
    }

    private String getAttributeValue(StartElement el, String attr) {
        return el.getAttributeByName(new QName(attr)).getValue();
    }

    private void log(String msg, LogLevel level) {
        if (this.logHandler != null) {
            this.logHandler.log(String.format("Parsing Model: %s", msg));
        } else {
            LogUtil.log("Parsing Model: " + msg, LogLevel.WARNING);
        }
    }

    public void endElement(EndElement xml) throws SAXException {
        if (xml.getName().getLocalPart().equals("element")) {
            this.objectStack.pop();
        }
    }

    public void writeCharacters(Characters characters) throws SAXException {
        String value = characters.getData();
        if (value == null || value.length() == 0) {
            return;
        }
        if (value.trim().equals("")) {
            return;
        }
        StackElement currentElement = this.objectStack.peek();
        if (currentElement.feature instanceof IAttributeFeature) {
            currentElement.element.giSetAttribute((IAttributeFeature)currentElement.feature, value);
        } else if (currentElement.feature instanceof IListFeature && !((IListFeature)currentElement.feature).isContainment()) {
            String[] idlist;
            ArrayList<Long> ids = new ArrayList<Long>();
            String[] stringArray = idlist = value.split(",");
            int n = idlist.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                Long id = StringUtil.toLong((String)next, (Long)-1L);
                if (id != -1L) {
                    ids.add(id);
                }
                ++n2;
            }
            IListHandle handle = currentElement.element.giGetList((IListFeature)currentElement.feature);
            ((ListHandleImpl)handle).setAllElementsByIdInject(ids, false);
        } else if (currentElement.feature instanceof IElementFeature && !((IElementFeature)currentElement.feature).isContainment()) {
            Long id = StringUtil.toLong((String)value, (Long)-1L);
            if (id != -1L) {
                IElementHandle handle = currentElement.element.giGetElement((IElementFeature)currentElement.feature);
                ((ElementHandleImpl)handle).setElementByIdInject(id, false);
            }
        } else {
            String ename = currentElement.element.giGetElementType().getName();
            String fname = currentElement.feature != null ? currentElement.feature.getName() : "???";
            throw new SAXException("Unexpected character data " + value + " for feature " + ename + ":" + fname);
        }
    }

    static class StackElement {
        IElement element;
        IFeature feature;

        public StackElement(IElement el) {
            this.element = el;
        }
    }
}

