/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.List;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceException;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinaryIbeeResourceWriterMultiFile {
    private void writeLong(OutputStream out, long l) throws IOException {
        int i = 7;
        while (i >= 0) {
            byte next = (byte)(l >> 8 * i);
            out.write(next);
            --i;
        }
    }

    private void writeInt(OutputStream out, int v) throws IOException {
        int i = 3;
        while (i >= 0) {
            byte next = (byte)(v >> 8 * i);
            out.write(next);
            --i;
        }
    }

    private void writeString(OutputStream out, String s) throws IOException {
        byte[] bytes = s.getBytes();
        this.writeInt(out, bytes.length);
        out.write(bytes);
    }

    public int write(IbeeResource resource, String baseDir, long lastSyncId) throws ResourceException {
        try {
            return this.write2(resource, baseDir, lastSyncId);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    private int write2(IbeeResource resource, String baseDir, long lastSyncId) throws IOException {
        Collection<IElement> objectsToWrite = resource.getAllObjects(lastSyncId);
        LogUtil.info("Write resource " + baseDir + ": writing " + objectsToWrite.size() + " objects ");
        FileUtil.createDir((String)baseDir);
        FileWriter writer = new FileWriter(baseDir + File.separator + "index");
        long rootId = resource.getRoot() != null ? resource.getRoot().giGetElementId() : -1L;
        writer.write("root=" + rootId);
        writer.close();
        for (IElement element : objectsToWrite) {
            FileOutputStream out = new FileOutputStream(baseDir + File.separator + element.giGetElementId() + ".dat");
            this.writeString(out, element.giGetElementType().getDomain().getName());
            this.writeInt(out, element.giGetElementType().getDomain().getTypeIndex(element.giGetElementType()));
            this.writeLong(out, element.giGetElementId());
            this.writeLong(out, element.giGetParent() != null ? element.giGetParent().giGetElementId() : -1L);
            for (IElementFeature<?> iElementFeature : element.giGetElementType().getElementFeatures()) {
                Object child = element.giGetElement(iElementFeature).getElement();
                if (child == null) continue;
                this.writeInt(out, 1);
                this.writeInt(out, element.giGetElementType().getElementFeatureIndex(iElementFeature));
                this.writeLong(out, child.giGetElementId());
            }
            for (IListFeature iListFeature : element.giGetElementType().getListFeatures()) {
                Collection childs = element.giGetList(iListFeature).getElements();
                if (childs.size() <= 0) continue;
                this.writeInt(out, 2);
                this.writeInt(out, element.giGetElementType().getListFeatureIndex(iListFeature));
                this.writeInt(out, childs.size());
                for (IElement child : childs) {
                    this.writeLong(out, child.giGetElementId());
                }
            }
            for (IAttributeFeature iAttributeFeature : element.giGetElementType().getAttributeFeatures()) {
                String value = element.giGetAttribute(iAttributeFeature, null);
                if (value == null || value.isEmpty()) continue;
                this.writeInt(out, 3);
                this.writeInt(out, element.giGetElementType().getAttributeFeatureIndex(iAttributeFeature));
                this.writeString(out, value);
            }
            ((OutputStream)out).close();
        }
        return objectsToWrite.size();
    }

    private void writeXml(List<IElement> objectsToWrite, String fileName) throws IOException {
        for (IElement element : objectsToWrite) {
            Element featureElement;
            long l;
            Document doc = XmlUtil.createNewDocument();
            Element rootElement = doc.createElement("element");
            doc.appendChild(rootElement);
            XmlUtil.setAttribute((Element)rootElement, (String)"type", (String)element.giGetElementType().getName(), (boolean)false);
            XmlUtil.setAttribute((Element)rootElement, (String)"domain", (String)element.giGetElementType().getDomain().getName(), (boolean)false);
            XmlUtil.setAttribute((Element)rootElement, (String)"id", (String)("" + element.giGetElementId()), (boolean)false);
            IElement parent = element.giGetParent();
            if (parent != null && (l = element.giGetParent().giGetElementId()) != -1L) {
                XmlUtil.setAttribute((Element)rootElement, (String)"parent", (String)("" + l), (boolean)true);
            }
            for (IElementFeature<?> iElementFeature : element.giGetElementType().getElementFeatures()) {
                Object child = element.giGetElement(iElementFeature).getElement();
                if (child == null) continue;
                featureElement = doc.createElement("element");
                rootElement.appendChild(featureElement);
                XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iElementFeature.getName(), (boolean)false);
                XmlUtil.setAttribute((Element)featureElement, (String)"id", (String)("" + child.giGetElementId()), (boolean)true);
            }
            for (IListFeature iListFeature : element.giGetElementType().getListFeatures()) {
                Collection childs = element.giGetList(iListFeature).getElements();
                if (childs.size() <= 0) continue;
                featureElement = doc.createElement("list");
                rootElement.appendChild(featureElement);
                XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iListFeature.getName(), (boolean)false);
                StringBuilder idsBuf = new StringBuilder();
                for (IElement child : childs) {
                    if (child == null) continue;
                    if (idsBuf.length() > 0) {
                        idsBuf.append(",");
                    }
                    idsBuf.append(child.giGetElementId());
                }
                XmlUtil.setAttribute((Element)featureElement, (String)"ids", (String)idsBuf.toString(), (boolean)true);
            }
            for (IAttributeFeature iAttributeFeature : element.giGetElementType().getAttributeFeatures()) {
                String value = element.giGetAttribute(iAttributeFeature, null);
                if (value == null || value.isEmpty()) continue;
                featureElement = doc.createElement("attribute");
                rootElement.appendChild(featureElement);
                XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iAttributeFeature.getName(), (boolean)false);
                featureElement.setTextContent(value);
            }
            XmlUtil.writeXmlFile((Document)doc, (String)fileName);
        }
    }

    private void writeIndex(IbeeResource resource, String baseDir) throws IOException {
        try (OutputStreamWriter writer = null;){
            writer = new FileWriter(baseDir + "index");
            IElement root = resource.getRoot();
            if (root != null) {
                writer.write("root:" + root.giGetElementId());
            }
        }
    }
}

