/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceException;
import net.edgemind.ibee.util.file.FileUtil;

public class BinaryIbeeResourceWriterSingleFile {
    private void writeLong(OutputStream out, long l) throws IOException {
        int i = 7;
        while (i >= 0) {
            byte next = (byte)(l >> 8 * i);
            out.write(next);
            --i;
        }
    }

    private void writeInt(OutputStream out, int v) throws IOException {
        int i = 3;
        while (i >= 0) {
            byte next = (byte)(v >> 8 * i);
            out.write(next);
            --i;
        }
    }

    private void writeString(OutputStream out, String s) throws IOException {
        byte[] bytes = s.getBytes();
        this.writeInt(out, bytes.length);
        out.write(bytes);
    }

    public int write(IbeeResource resource, String baseDir, long lastSyncId) throws ResourceException {
        try {
            FileUtil.createDir((String)baseDir);
            FileOutputStream out = new FileOutputStream(baseDir + File.separator + "data.bin");
            Collection<IElement> objectsToWrite = resource.getAllObjects(-1L);
            LogUtil.info("Write resource " + baseDir + ": writing " + objectsToWrite.size() + " objects ");
            long rootId = resource.getRoot() != null ? resource.getRoot().giGetElementId() : -1L;
            this.writeLong(out, rootId);
            this.writeLong(out, objectsToWrite.size());
            for (IElement element : objectsToWrite) {
                this.writeElement(resource, element, out);
            }
            out.close();
            return objectsToWrite.size();
        }
        catch (IOException io) {
            throw new ResourceException(io);
        }
    }

    private void writeElement(IbeeResource resource, IElement element, FileOutputStream out) throws IOException {
        this.writeString(out, element.giGetElementType().getDomain().getName());
        this.writeInt(out, element.giGetElementType().getDomain().getTypeIndex(element.giGetElementType()));
        this.writeLong(out, element.giGetElementId());
        this.writeLong(out, element.giGetParent() != null ? element.giGetParent().giGetElementId() : -1L);
        this.writeLong(out, this.getFeatureCnt(element));
        for (IElementFeature<?> iElementFeature : element.giGetElementType().getElementFeatures()) {
            Object child = element.giGetElement(iElementFeature).getElement();
            if (child == null) continue;
            this.writeInt(out, 1);
            this.writeInt(out, element.giGetElementType().getElementFeatureIndex(iElementFeature));
            this.writeLong(out, child.giGetElementId());
        }
        for (IListFeature iListFeature : element.giGetElementType().getListFeatures()) {
            Collection childs = element.giGetList(iListFeature).getElements();
            if (childs.size() <= 0) continue;
            this.writeInt(out, 2);
            this.writeInt(out, element.giGetElementType().getListFeatureIndex(iListFeature));
            this.writeInt(out, childs.size());
            for (IElement child : childs) {
                this.writeLong(out, child.giGetElementId());
            }
        }
        for (IAttributeFeature iAttributeFeature : element.giGetElementType().getAttributeFeatures()) {
            String value = element.giGetAttribute(iAttributeFeature, null);
            if (value == null || value.isEmpty()) continue;
            this.writeInt(out, 3);
            this.writeInt(out, element.giGetElementType().getAttributeFeatureIndex(iAttributeFeature));
            this.writeString(out, value);
        }
    }

    private long getFeatureCnt(IElement element) {
        long featureCnt = 0L;
        for (IElementFeature<?> iElementFeature : element.giGetElementType().getElementFeatures()) {
            Object child = element.giGetElement(iElementFeature).getElement();
            if (child == null) continue;
            ++featureCnt;
        }
        for (IListFeature iListFeature : element.giGetElementType().getListFeatures()) {
            Collection childs = element.giGetList(iListFeature).getElements();
            if (childs.size() <= 0) continue;
            ++featureCnt;
        }
        for (IAttributeFeature iAttributeFeature : element.giGetElementType().getAttributeFeatures()) {
            String value = element.giGetAttribute(iAttributeFeature, null);
            if (value == null || value.isEmpty()) continue;
            ++featureCnt;
        }
        return featureCnt;
    }
}

