/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.writer;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceException;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlIbeeResourceWriterMultiFile {
    public int write(IbeeResource resource, String baseDir, long lastSyncId) throws ResourceException {
        LogUtil.info("Write resource: last syncid " + lastSyncId);
        Collection<IElement> objectsToWrite = resource.getAllObjects(lastSyncId);
        LogUtil.info("Write resource " + baseDir + ": writing " + objectsToWrite.size() + " objects ");
        try {
            FileUtil.createDir((String)baseDir);
            this.writeIndex(resource, baseDir);
            this.writeXml(objectsToWrite, baseDir);
        }
        catch (IOException io) {
            throw new ResourceException(io);
        }
        return objectsToWrite.size();
    }

    private void writeXml(Collection<IElement> objectsToWrite, String baseDir) throws IOException {
        for (IElement element : objectsToWrite) {
            Element featureElement;
            long l;
            Document doc = XmlUtil.createNewDocument();
            Element rootElement = doc.createElement("element");
            doc.appendChild(rootElement);
            XmlUtil.setAttribute((Element)rootElement, (String)"type", (String)element.giGetElementType().getName(), (boolean)false);
            XmlUtil.setAttribute((Element)rootElement, (String)"domain", (String)element.giGetElementType().getDomain().getName(), (boolean)false);
            XmlUtil.setAttribute((Element)rootElement, (String)"id", (String)("" + element.giGetElementId()), (boolean)false);
            IElement parent = element.giGetParent();
            if (parent != null && (l = element.giGetParent().giGetElementId()) != -1L) {
                XmlUtil.setAttribute((Element)rootElement, (String)"parent", (String)("" + l), (boolean)true);
            }
            for (IElementFeature<?> iElementFeature : element.giGetElementType().getElementFeatures()) {
                Object child = element.giGetElement(iElementFeature).getElement();
                if (child == null) continue;
                featureElement = doc.createElement("element");
                rootElement.appendChild(featureElement);
                XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iElementFeature.getName(), (boolean)false);
                XmlUtil.setAttribute((Element)featureElement, (String)"id", (String)("" + child.giGetElementId()), (boolean)true);
            }
            for (IListFeature iListFeature : element.giGetElementType().getListFeatures()) {
                Collection childs = element.giGetList(iListFeature).getElements();
                if (childs.size() <= 0) continue;
                featureElement = doc.createElement("list");
                rootElement.appendChild(featureElement);
                XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iListFeature.getName(), (boolean)false);
                StringBuilder idsBuf = new StringBuilder();
                for (IElement child : childs) {
                    if (child == null) continue;
                    if (idsBuf.length() > 0) {
                        idsBuf.append(",");
                    }
                    idsBuf.append(child.giGetElementId());
                }
                XmlUtil.setAttribute((Element)featureElement, (String)"ids", (String)idsBuf.toString(), (boolean)true);
            }
            for (IAttributeFeature iAttributeFeature : element.giGetElementType().getAttributeFeatures()) {
                String value = element.giGetAttribute(iAttributeFeature, null);
                if (value == null || value.isEmpty()) continue;
                featureElement = doc.createElement("attribute");
                rootElement.appendChild(featureElement);
                XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iAttributeFeature.getName(), (boolean)false);
                featureElement.setTextContent(value);
            }
            String string = baseDir + element.giGetElementId() + ".xml";
            XmlUtil.writeXmlFile((Document)doc, (String)string);
        }
    }

    private void writeIndex(IbeeResource resource, String baseDir) throws IOException {
        try (OutputStreamWriter writer = null;){
            writer = new FileWriter(baseDir + "index");
            IElement root = resource.getRoot();
            if (root != null) {
                writer.write("root:" + root.giGetElementId());
            }
        }
    }
}

