/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.writer;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceException;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlIbeeResourceWriterSingleFile {
    public int write(IbeeResource resource, String resourceDir, long lastSyncId) throws ResourceException {
        Collection<IElement> objectsToWrite = resource.getAllObjects(-1L);
        String xmlFile = resourceDir + File.separator + "data.xml";
        LogUtil.info("Write resource " + xmlFile + ": writing " + objectsToWrite.size() + " objects ");
        Document doc = XmlUtil.createNewDocument();
        Element rootXml = doc.createElement("model");
        doc.appendChild(rootXml);
        if (resource.getRoot() != null) {
            doc.getDocumentElement().setAttribute("root", "" + resource.getRoot().giGetElementId());
        }
        try {
            this.writeXml(objectsToWrite, doc);
            XmlUtil.writeXmlFile((Document)doc, (String)xmlFile);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        return objectsToWrite.size();
    }

    private void writeXml(Collection<IElement> objectsToWrite, Document doc) throws IOException {
        for (IElement element : objectsToWrite) {
            Element featureElement;
            long l;
            Element childXml = doc.createElement("element");
            doc.getDocumentElement().appendChild(childXml);
            XmlUtil.setAttribute((Element)childXml, (String)"type", (String)element.giGetElementType().getName(), (boolean)false);
            XmlUtil.setAttribute((Element)childXml, (String)"domain", (String)element.giGetElementType().getDomain().getName(), (boolean)false);
            XmlUtil.setAttribute((Element)childXml, (String)"id", (String)("" + element.giGetElementId()), (boolean)false);
            IElement parent = element.giGetParent();
            if (parent != null && (l = element.giGetParent().giGetElementId()) != -1L) {
                XmlUtil.setAttribute((Element)childXml, (String)"parent", (String)("" + l), (boolean)true);
            }
            for (IElementFeature<?> iElementFeature : element.giGetElementType().getElementFeatures()) {
                Object child = element.giGetElement(iElementFeature).getElement();
                if (child == null) continue;
                featureElement = doc.createElement("element");
                childXml.appendChild(featureElement);
                XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iElementFeature.getName(), (boolean)false);
                XmlUtil.setAttribute((Element)featureElement, (String)"id", (String)("" + child.giGetElementId()), (boolean)true);
            }
            for (IListFeature iListFeature : element.giGetElementType().getListFeatures()) {
                Collection childs = element.giGetList(iListFeature).getElements();
                if (childs.size() <= 0) continue;
                featureElement = doc.createElement("list");
                childXml.appendChild(featureElement);
                XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iListFeature.getName(), (boolean)false);
                StringBuilder idsBuf = new StringBuilder();
                for (IElement child : childs) {
                    if (child == null) continue;
                    if (idsBuf.length() > 0) {
                        idsBuf.append(",");
                    }
                    idsBuf.append(child.giGetElementId());
                }
                XmlUtil.setAttribute((Element)featureElement, (String)"ids", (String)idsBuf.toString(), (boolean)true);
            }
            for (IAttributeFeature iAttributeFeature : element.giGetElementType().getAttributeFeatures()) {
                String value = element.giGetAttribute(iAttributeFeature, null);
                if (value == null || value.isEmpty()) continue;
                featureElement = doc.createElement("attribute");
                childXml.appendChild(featureElement);
                XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iAttributeFeature.getName(), (boolean)false);
                featureElement.setTextContent(value);
            }
        }
    }
}

