/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.writer.sax;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.exception.ManualInteruptionException;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.eclipse.core.runtime.IProgressMonitor;

public class SaxIbeeResourceWriterGeneric {
    private XMLStreamWriter out;
    private int indent = 0;
    private IProgressMonitor monitor;
    private int objectCountTotal;
    private int objectCount;
    private int lastProgress;

    public void write(IbeeResource resource, File file) {
        this.write(resource, file, this.monitor, null);
    }

    public void write(IbeeResource resource, File file, IProgressMonitor monitor, ILogHandler userIo) throws IbeeException {
        this.monitor = monitor;
        this.objectCountTotal = this.countElements(resource);
        this.objectCount = 0;
        this.lastProgress = 0;
        try {
            ZipOutputStream outputStream = null;
            this.out = null;
            try {
                if (monitor != null) {
                    monitor.beginTask("Save Andromeda Model", 100);
                }
                outputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                outputStream.putNextEntry(new ZipEntry("_model.xml"));
                this.out = XmlUtil.createStreamWriter((Writer)new OutputStreamWriter((OutputStream)outputStream, "UTF-8"));
                this.out.writeStartDocument();
                this.writeResource(resource);
                this.out.writeEndDocument();
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
                if (this.out != null) {
                    this.out.flush();
                    outputStream.closeEntry();
                    outputStream.close();
                    this.out.close();
                }
            }
        }
        catch (Exception e) {
            if (e instanceof IbeeException) {
                throw (IbeeException)e;
            }
            throw new IbeeException(e);
        }
        resource.setDirty(false);
    }

    private void writeResource(IbeeResource resource) throws ManualInteruptionException, XMLStreamException {
        IElement root = resource.getRoot();
        if (root != null) {
            this.writeElement(root);
        }
    }

    private void writeElement(IElement element) throws XMLStreamException, ManualInteruptionException {
        this.nl();
        this.out.writeStartElement("element");
        this.out.writeAttribute("domain", element.giGetElementType().getDomain().getName());
        this.out.writeAttribute("id", "" + element.giGetElementId());
        this.out.writeAttribute("type", element.giGetElementType().getName());
        ++this.indent;
        this.writeAttributes(element);
        this.writeChildElements(element);
        this.writeChildLists(element);
        --this.indent;
        this.nl();
        this.out.writeEndElement();
        if (this.monitor != null) {
            ++this.objectCount;
            int progress = this.objectCount * 100 / this.objectCountTotal;
            int delta = progress - this.lastProgress;
            if (delta > 0) {
                this.monitor.worked(delta);
                this.lastProgress = progress;
                if (this.monitor.isCanceled()) {
                    throw new ManualInteruptionException("Reading procedure has been canceled");
                }
            }
        }
    }

    private void nl() throws XMLStreamException {
        this.out.writeCharacters(FileUtil.lineSeparator());
        char[] chars = new char[this.indent];
        int i = 0;
        while (i < this.indent) {
            chars[i] = 32;
            ++i;
        }
        String s = new String(chars);
        this.out.writeCharacters(s);
    }

    private void writeAttributes(IElement element) throws XMLStreamException {
        for (IAttributeFeature feature : element.giGetElementType().getAttributeFeatures()) {
            String value = element.giGetAttribute(feature);
            if (value == null || value.length() <= 0) continue;
            this.nl();
            this.out.writeStartElement("attribute");
            this.out.writeAttribute("name", feature.getName());
            this.out.writeCharacters(element.giGetAttribute(feature));
            this.out.writeEndElement();
        }
    }

    private void writeChildLists(IElement element) throws XMLStreamException, ManualInteruptionException {
        for (IListFeature<IElement> feature : element.giGetElementType().getListFeatures()) {
            Collection<IElement> children = element.giGetList(feature).getElements();
            if (children == null || children.size() <= 0) continue;
            this.nl();
            this.out.writeStartElement("list");
            this.out.writeAttribute("name", feature.getName());
            if (feature.isContainment()) {
                ++this.indent;
                for (IElement child : children) {
                    this.writeElement(child);
                }
                --this.indent;
                this.nl();
            } else {
                StringBuffer buf = new StringBuffer();
                for (IElement child : children) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append(child.giGetElementId());
                }
                this.out.writeCharacters(buf.toString());
            }
            this.out.writeEndElement();
        }
    }

    private void writeChildElements(IElement element) throws XMLStreamException, ManualInteruptionException {
        for (IElementFeature<?> feature : element.giGetElementType().getElementFeatures()) {
            Object child = element.giGetElement(feature).getElement();
            if (child == null) continue;
            this.nl();
            this.out.writeStartElement("child");
            this.out.writeAttribute("name", feature.getName());
            if (feature.isContainment()) {
                ++this.indent;
                this.writeElement((IElement)child);
                --this.indent;
                this.nl();
            } else {
                this.out.writeCharacters("" + child.giGetElementId());
            }
            this.out.writeEndElement();
        }
    }

    public int countElements(IbeeResource resource) {
        return resource.getSize();
    }
}

