/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.writer.sax;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.exception.ManualInteruptionException;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.LibraryDescriptor;
import net.edgemind.ibee.core.resource.ResourceIOException;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.eclipse.core.runtime.IProgressMonitor;

public class XmlImfResourceWriterSax {
    private XMLStreamWriter writer;
    private int indent = 0;
    private IProgressMonitor monitor;
    private int objectCountTotal;
    private int objectCount;
    private int lastProgress;
    private boolean zipped = true;

    public void setZipped(boolean value) {
        this.zipped = value;
    }

    public void write(IbeeResource resource, File file) throws ResourceIOException {
        this.write(resource, file, this.monitor, null);
    }

    public void write(IbeeResource resource, File file, IProgressMonitor monitor, ILogHandler logHandler) throws ResourceIOException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStream outputStream = this.createFileOutputStream(file);){
                this.performWrite(resource, outputStream, monitor, logHandler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            throw new ResourceIOException(exception);
        }
    }

    public void write(IbeeResource resource, OutputStream outputStream) {
        this.write(resource, outputStream, null, null);
    }

    public void write(IbeeResource resource, OutputStream outputStream, IProgressMonitor monitor, ILogHandler logHandler) throws ResourceIOException {
        try {
            this.performWrite(resource, outputStream, monitor, logHandler);
        }
        catch (IOException e) {
            throw new ResourceIOException(e);
        }
    }

    private void performWrite(IbeeResource resource, OutputStream outputStream, IProgressMonitor monitor, ILogHandler logHandler) throws IOException {
        if (this.zipped) {
            outputStream = this.createZippedOutputStream(outputStream);
        }
        this.monitor = monitor;
        this.objectCountTotal = this.countElements(resource);
        this.objectCount = 0;
        this.lastProgress = 0;
        try {
            this.writer = null;
            try {
                if (monitor != null) {
                    monitor.beginTask("Save Andromeda Model", 100);
                }
                this.writer = XmlUtil.createStreamWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"));
                this.writer.writeStartDocument();
                this.writer.writeStartElement("resource");
                ++this.indent;
                this.writeMetaSection(resource);
                this.writeLibraries(resource);
                this.writeResource(resource);
                --this.indent;
                this.nl();
                this.writer.writeEndElement();
                this.writer.writeEndDocument();
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
                if (this.writer != null) {
                    this.writer.flush();
                    if (outputStream != null) {
                        if (outputStream instanceof ZipOutputStream) {
                            ((ZipOutputStream)outputStream).closeEntry();
                        }
                        outputStream.close();
                    }
                    this.writer.close();
                }
            }
        }
        catch (Exception e) {
            if (e instanceof IbeeException) {
                throw (IbeeException)e;
            }
            throw new IbeeException(e);
        }
        resource.setDirty(false);
    }

    private OutputStream createFileOutputStream(File file) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    private OutputStream createZippedOutputStream(OutputStream stream) throws IOException {
        ZipOutputStream outputStream = new ZipOutputStream(stream);
        outputStream.putNextEntry(new ZipEntry("_model.xml"));
        return outputStream;
    }

    private void writeLibraries(IbeeResource resource) throws IOException, XMLStreamException {
        List<IbeeLibrary> libs = resource.getLibraries();
        if (libs.size() == 0) {
            return;
        }
        this.nl();
        this.writer.writeStartElement("libraries");
        ++this.indent;
        for (IbeeLibrary library : libs) {
            this.nl();
            LibraryDescriptor desc = resource.getDescriptor(library);
            this.writer.writeStartElement("library");
            ++this.indent;
            this.nl();
            this.writer.writeStartElement("name");
            this.writer.writeCharacters(library.getName());
            this.writer.writeEndElement();
            this.nl();
            this.writer.writeStartElement("url");
            this.writer.writeCharacters(desc.getUrl());
            this.writer.writeEndElement();
            --this.indent;
            this.nl();
            this.writer.writeEndElement();
        }
        --this.indent;
        this.nl();
        this.writer.writeEndElement();
    }

    private void writeMetaSection(IbeeResource resource) throws IOException, XMLStreamException {
        this.writeMetaSection("xml-writer-name", "SaxResourceWriter");
        this.writeMetaSection("xml-writer-version", "1.0");
        IElement e = resource.getRoot();
        if (e != null) {
            IDomain domain = e.giGetElementType().getDomain();
            this.writeMetaSection("domain-name", domain.getName() != null ? domain.getName() : "???");
            this.writeMetaSection("domain-version", domain.getVersion() != null ? domain.getVersion() : "1.0");
        }
    }

    private void writeMetaSection(String name, String value) throws IOException, XMLStreamException {
        this.nl();
        this.writer.writeStartElement("meta");
        this.writer.writeAttribute(name, value);
        this.writer.writeEndElement();
    }

    private void writeResource(IbeeResource resource) throws ManualInteruptionException, XMLStreamException {
        IElement root = resource.getRoot();
        if (root != null) {
            this.writeElementDefinition(root, true);
        }
    }

    private void writeElementDefinition(IElement element, boolean isRoot) throws XMLStreamException, ManualInteruptionException {
        this.nl();
        String tagName = isRoot ? "root" : element.giGetElementType().getName();
        this.writer.writeStartElement(tagName);
        this.writer.writeAttribute("id", "" + element.giGetElementId());
        if (element.giGetParent() == null) {
            this.writer.writeAttribute("type", element.giGetElementType().getName());
            this.writer.writeAttribute("domain", element.giGetElementType().getDomain().getName());
        } else if (element.giGetParent().giGetElementType().getDomain() != element.giGetElementType().getDomain()) {
            this.writer.writeAttribute("domain", element.giGetElementType().getDomain().getName());
        }
        ++this.indent;
        this.writeElementContent(element);
        --this.indent;
        this.nl();
        this.writer.writeEndElement();
        if (this.monitor != null) {
            ++this.objectCount;
            int progress = this.objectCount * 100 / this.objectCountTotal;
            int delta = progress - this.lastProgress;
            if (delta > 0) {
                this.monitor.worked(delta);
                this.lastProgress = progress;
                if (this.monitor.isCanceled()) {
                    throw new ManualInteruptionException("Reading procedure has been canceled");
                }
            }
        }
    }

    private void writeElementContent(IElement element) throws XMLStreamException, ManualInteruptionException {
        this.writeAttributes(element);
        this.writeChildElements(element);
        this.writeChildLists(element);
    }

    private void nl() throws XMLStreamException {
        this.writer.writeCharacters(FileUtil.lineSeparator());
        char[] chars = new char[this.indent];
        int i = 0;
        while (i < this.indent) {
            chars[i] = 32;
            ++i;
        }
        String s = new String(chars);
        this.writer.writeCharacters(s);
    }

    private void writeAttributes(IElement element) throws XMLStreamException {
        for (IAttributeFeature feature : element.giGetElementType().getAttributeFeatures()) {
            String value = element.giGetAttribute(feature);
            if (value == null || value.length() <= 0) continue;
            this.nl();
            this.writer.writeStartElement(feature.getName());
            this.writer.writeCharacters(element.giGetAttribute(feature));
            this.writer.writeEndElement();
        }
    }

    private void writeChildLists(IElement element) throws XMLStreamException, ManualInteruptionException {
        for (IListFeature<IElement> feature : element.giGetElementType().getListFeatures()) {
            Collection<IElement> children = element.giGetList(feature).getElements();
            if (children == null || children.size() <= 0) continue;
            this.nl();
            this.writer.writeStartElement(feature.getName());
            if (feature.isContainment()) {
                ++this.indent;
                for (IElement child : children) {
                    this.writeElementDefinition(child, false);
                }
                --this.indent;
                this.nl();
            } else {
                StringBuffer buf = new StringBuffer();
                for (IElement child : children) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append(child.giGetElementId());
                }
                this.writer.writeAttribute("reflist", "true");
                this.writer.writeCharacters(buf.toString());
            }
            this.writer.writeEndElement();
        }
    }

    private void writeChildElements(IElement element) throws XMLStreamException, ManualInteruptionException {
        for (IElementFeature<?> feature : element.giGetElementType().getElementFeatures()) {
            Object child = element.giGetElement(feature).getElement();
            if (child == null) continue;
            this.nl();
            String tagName = feature.getName();
            this.writer.writeStartElement(tagName);
            if (feature.isContainment()) {
                this.writer.writeAttribute("id", "" + child.giGetElementId());
                boolean explicitTypeDeclaration = true;
                if (explicitTypeDeclaration) {
                    this.writer.writeAttribute("type", child.giGetElementType().getName());
                    if (child.giGetElementType().getDomain() != element.giGetElementType().getDomain()) {
                        this.writer.writeAttribute("domain", child.giGetElementType().getDomain().getName());
                    }
                }
                ++this.indent;
                this.writeElementContent((IElement)child);
                --this.indent;
                this.nl();
            } else {
                this.writer.writeAttribute("ref", "true");
                this.writer.writeCharacters("" + child.giGetElementId());
            }
            this.writer.writeEndElement();
        }
    }

    public int countElements(IbeeResource resource) {
        return resource.getSize();
    }
}

