/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import net.edgemind.ibee.core.resource.FileResource;
import net.edgemind.ibee.core.resource.ResourceFactory;
import net.edgemind.ibee.core.resource.reader.BinaryFileResourceReader;
import net.edgemind.ibee.core.resource.type.FileResourceType;
import net.edgemind.ibee.core.resource.writer.BinaryFileResourceWriter;
import org.junit.Assert;
import org.junit.Test;

public class FileResourceTests {
    @Test
    public void testWriteResource() {
        try {
            FileResource resource = (FileResource)ResourceFactory.getInstance().createResource(FileResourceType.getInstance());
            BinaryFileResourceWriter writer = new BinaryFileResourceWriter(resource);
            StringBuffer buf = new StringBuffer();
            buf.append("This is a test file \n\n");
            buf.append("line 1: This is line 1\n");
            buf.append("line 2: This is line 2\n");
            resource.setData(buf.toString().getBytes());
            File file = File.createTempFile("test", "bin");
            writer.writeContent(file.getAbsolutePath());
            byte[] bytes = new byte[1000];
            FileInputStream reader = new FileInputStream(file);
            int count = reader.read(bytes);
            reader.close();
            String resourceString = new String(bytes, 0, count);
            Assert.assertTrue((boolean)resourceString.equals(buf.toString()));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testReadResource() {
        try {
            FileResource resource = (FileResource)ResourceFactory.getInstance().createResource(FileResourceType.getInstance());
            File file = File.createTempFile("test", "bin");
            FileWriter writer = new FileWriter(file);
            StringBuffer buf = new StringBuffer();
            buf.append("This is a test file \n\n");
            buf.append("line 1: This is line 1\n");
            buf.append("line 2: This is line 2\n");
            writer.write(buf.toString());
            writer.close();
            BinaryFileResourceReader reader = new BinaryFileResourceReader(resource);
            reader.readContent(file.getAbsolutePath());
            String resourceString = new String(resource.getData());
            Assert.assertTrue((boolean)resourceString.equals(buf.toString()));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }
}

