/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.util;

import java.util.function.Consumer;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.util.exec.IFunctionWithException;
import net.edgemind.ibee.util.exec.IFunctionWithException1;
import net.edgemind.ibee.util.exec.IFunctionWithException2;
import net.edgemind.ibee.util.exec.IFunctionWithException3;
import net.edgemind.ibee.util.exec.IFunctionWithException4;
import net.edgemind.ibee.util.exec.IRunnableWithException;
import net.edgemind.ibee.util.exec.IRunnableWithException1;
import net.edgemind.ibee.util.exec.IRunnableWithException2;
import net.edgemind.ibee.util.exec.IRunnableWithException3;
import net.edgemind.ibee.util.exec.IRunnableWithException4;

public class ExecUtil {
    public static void execSafe(IRunnableWithException f) throws IbeeException {
        ExecUtil.execSafe(f, true);
    }

    public static void execSafe(IRunnableWithException f, boolean cont) throws IbeeException {
        try {
            f.run();
        }
        catch (Exception e) {
            ExecUtil.handleError(e, cont);
        }
    }

    public static <T> T execSafe(IFunctionWithException<T> f) throws IbeeException {
        return ExecUtil.execSafe(f, true);
    }

    public static <T> T execSafe(IFunctionWithException<T> f, boolean cont) throws IbeeException {
        try {
            return (T)f.run();
        }
        catch (Exception e) {
            ExecUtil.handleError(e, cont);
            return null;
        }
    }

    public static <U> void execSafe(IRunnableWithException1<U> f, U arg1) throws IbeeException {
        ExecUtil.execSafe(f, arg1, true);
    }

    public static <U> void execSafe(IRunnableWithException1<U> f, U arg1, boolean cont) throws IbeeException {
        try {
            f.run(arg1);
        }
        catch (Exception e) {
            ExecUtil.handleError(e, cont);
        }
    }

    public static <T, U> T execSafe(IFunctionWithException1<T, U> f, U arg1) throws IbeeException {
        return ExecUtil.execSafe(f, arg1, true);
    }

    public static <T, U> T execSafe(IFunctionWithException1<T, U> f, U arg1, boolean cont) throws IbeeException {
        try {
            return (T)f.run(arg1);
        }
        catch (Exception e) {
            ExecUtil.handleError(e, cont);
            return null;
        }
    }

    public static <U, V> void execSafe(IRunnableWithException2<U, V> f, U arg1, V arg2) throws IbeeException {
        ExecUtil.execSafe(f, arg1, arg2, true);
    }

    public static <U, V> void execSafe(IRunnableWithException2<U, V> f, U arg1, V arg2, boolean cont) throws IbeeException {
        try {
            f.run(arg1, arg2);
        }
        catch (Exception e) {
            ExecUtil.handleError(e, cont);
        }
    }

    public static <T, U, V> T execSafe(IFunctionWithException2<T, U, V> f, U arg1, V arg2) throws IbeeException {
        return ExecUtil.execSafe(f, arg1, arg2, true);
    }

    public static <T, U, V> T execSafe(IFunctionWithException2<T, U, V> f, U arg1, V arg2, boolean cont) throws IbeeException {
        try {
            return (T)f.run(arg1, arg2);
        }
        catch (Exception e) {
            ExecUtil.handleError(e, cont);
            return null;
        }
    }

    public static <U, V, W> void execSafe(IRunnableWithException3<U, V, W> f, U arg1, V arg2, W arg3) throws IbeeException {
        ExecUtil.execSafe(f, arg1, arg2, arg3, true);
    }

    public static <U, V, W> void execSafe(IRunnableWithException3<U, V, W> f, U arg1, V arg2, W arg3, boolean cont) throws IbeeException {
        try {
            f.run(arg1, arg2, arg3);
        }
        catch (Exception e) {
            ExecUtil.handleError(e, cont);
        }
    }

    public static <T, U, V, W> T execSafe(IFunctionWithException3<T, U, V, W> f, U arg1, V arg2, W arg3) throws IbeeException {
        return ExecUtil.execSafe(f, arg1, arg2, arg3, true);
    }

    public static <T, U, V, W> T execSafe(IFunctionWithException3<T, U, V, W> f, U arg1, V arg2, W arg3, boolean cont) throws IbeeException {
        try {
            return (T)f.run(arg1, arg2, arg3);
        }
        catch (Exception e) {
            ExecUtil.handleError(e, cont);
            return null;
        }
    }

    public static <U, V, W, X> void execSafe(IRunnableWithException4<U, V, W, X> f, U arg1, V arg2, W arg3, X arg4) throws IbeeException {
        ExecUtil.execSafe(f, arg1, arg2, arg3, arg4, true);
    }

    public static <U, V, W, X> void execSafe(IRunnableWithException4<U, V, W, X> f, U arg1, V arg2, W arg3, X arg4, boolean cont) throws IbeeException {
        try {
            f.run(arg1, arg2, arg3, arg4);
        }
        catch (Exception e) {
            ExecUtil.handleError(e, cont);
        }
    }

    public static <T, U, V, W, X> T execSafe(IFunctionWithException4<T, U, V, W, X> f, U arg1, V arg2, W arg3, X arg4) throws IbeeException {
        return ExecUtil.execSafe(f, arg1, arg2, arg3, arg4, true);
    }

    public static <T, U, V, W, X> T execSafe(IFunctionWithException4<T, U, V, W, X> f, U arg1, V arg2, W arg3, X arg4, boolean cont) throws IbeeException {
        try {
            return (T)f.run(arg1, arg2, arg3, arg4);
        }
        catch (Exception e) {
            ExecUtil.handleError(e, cont);
            return null;
        }
    }

    private static void handleError(Exception e, boolean cont) throws IbeeException {
        if (!cont) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IbeeException(e);
        }
        LogUtil.log(e);
    }

    public static void execThreaded(IRunnableWithException f, Runnable onSuccess, Consumer<Throwable> onError) throws IbeeException {
        Thread thread = new Thread(() -> {
            block3: {
                try {
                    f.run();
                    if (onSuccess != null) {
                        onSuccess.run();
                    }
                }
                catch (Throwable err) {
                    if (onError == null) break block3;
                    onError.accept(err);
                }
            }
        });
        thread.start();
    }

    public static <T> void execThreaded(IFunctionWithException<T> f, Consumer<T> onSuccess, Consumer<Throwable> onError) throws IbeeException {
        Thread thread = new Thread(() -> {
            block3: {
                try {
                    Object res = f.run();
                    if (onSuccess != null) {
                        onSuccess.accept(res);
                    }
                }
                catch (Throwable err) {
                    if (onError == null) break block3;
                    onError.accept(err);
                }
            }
        });
        thread.start();
    }
}

