/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.util.ModelUtilImf;
import net.edgemind.ibee.util.misc.IFilter;

public class ImfElementFinder {
    private boolean ignoreCase = true;
    private boolean considerMainResource = true;

    ImfElementFinder() {
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean getConsiderMainResource() {
        return this.considerMainResource;
    }

    public void setConsiderMainResource(boolean considerMainResource) {
        this.considerMainResource = considerMainResource;
    }

    public <T extends IElement> List<T> findElements(IElement parent, IElementType<T> type, boolean rec) {
        ArrayList<IElement> result = new ArrayList<IElement>();
        this.findElementsInternal(parent, (IFilter<IElement>)((IFilter)el -> this.testType((IElement)el, type)), rec, result);
        return result;
    }

    public <T extends IElement> List<T> findElements(IElement parent, IElementType<T> type, IFilter<T> filter, boolean rec) {
        ArrayList<IElement> result = new ArrayList<IElement>();
        this.findElementsInternal(parent, (IFilter<IElement>)((IFilter)el -> this.testType((IElement)el, type) && filter.accept(el)), rec, result);
        return result;
    }

    public List<IElement> findElements(IElement parent, IFilter<IElement> filter, boolean rec) {
        ArrayList<IElement> result = new ArrayList<IElement>();
        this.findElementsInternal(parent, filter, rec, result);
        return result;
    }

    private void findElementsInternal(IElement parent, IFilter<IElement> filter, boolean rec, List<IElement> result) {
        for (IElementFeature<?> iElementFeature : parent.giGetElementType().getElementFeatures()) {
            Object e;
            if (!iElementFeature.isContainment() || (e = parent.giGetElement(iElementFeature).getElement()) == null) continue;
            if (filter == null || filter.accept(e)) {
                result.add((IElement)e);
            }
            if (!rec) continue;
            this.findElementsInternal((IElement)e, filter, rec, result);
        }
        for (IListFeature iListFeature : parent.giGetElementType().getListFeatures()) {
            if (!iListFeature.isContainment()) continue;
            Collection list = parent.giGetList(iListFeature).getElements();
            for (IElement e : list) {
                if (filter == null || filter.accept((Object)e)) {
                    result.add(e);
                }
                if (!rec) continue;
                this.findElementsInternal(e, filter, rec, result);
            }
        }
    }

    public <T extends IElement> T findFirst(IElement parent, IElementType<T> type, IAttributeFeature attrFeature, String value, boolean rec) {
        String attrName = attrFeature.getName();
        return (T)this.findFirst(parent, (IFilter<IElement>)((IFilter)element -> this.testType((IElement)element, type) && this.testAttribute((IElement)element, attrName, value)), rec);
    }

    public <T extends IElement> T findFirst(IElement parent, IElementType<T> type, String attr, String value, boolean rec) {
        return (T)this.findFirst(parent, (IFilter<IElement>)((IFilter)element -> this.testType((IElement)element, type) && this.testAttribute((IElement)element, attr, value)), rec);
    }

    public <T extends IElement> T findFirst(IElement parent, IElementType<T> type, IFilter<IElement> filter, boolean rec) {
        return (T)this.findFirst(parent, (IFilter<IElement>)((IFilter)element -> this.testType((IElement)element, type) && filter.accept(element)), rec);
    }

    public <T extends IElement> T findFirst(IElement parent, IElementType<T> type, boolean rec) {
        return (T)this.findFirst(parent, (IFilter<IElement>)((IFilter)element -> this.testType((IElement)element, type)), rec);
    }

    public IElement findFirst(IElement parent, IFilter<IElement> filter, boolean rec) {
        if (filter.accept((Object)parent)) {
            return parent;
        }
        for (IElementFeature<?> iElementFeature : parent.giGetElementType().getElementFeatures()) {
            IElement test;
            Object e;
            if (!iElementFeature.isContainment() || (e = parent.giGetElement(iElementFeature).getElement()) == null) continue;
            if (filter.accept(e)) {
                return e;
            }
            if (!rec || (test = this.findFirst((IElement)e, filter, rec)) == null) continue;
            return test;
        }
        for (IListFeature iListFeature : parent.giGetElementType().getListFeatures()) {
            if (!iListFeature.isContainment()) continue;
            Collection list = parent.giGetList(iListFeature).getElements();
            for (IElement e : list) {
                IElement test;
                if (filter.accept((Object)e)) {
                    return e;
                }
                if (!rec || (test = this.findFirst(e, filter, rec)) == null) continue;
                return test;
            }
        }
        return null;
    }

    public <T extends IElement> List<T> findElements(IbeeResource resource, IElementType<T> type, String attr, String value, boolean withLibs) {
        return this.findElements(resource, (IFilter<IElement>)((IFilter)e -> this.testType((IElement)e, type) && this.testAttribute((IElement)e, attr, value)), withLibs);
    }

    public <T extends IElement> List<T> findElements(IbeeResource resource, IElementType<T> type, IFilter<IElement> filter, boolean withLibs) {
        return this.findElements(resource, (IFilter<IElement>)((IFilter)e -> this.testType((IElement)e, type) && filter.accept(e)), withLibs);
    }

    public <T extends IElement> List<T> findElements(IbeeResource resource, IElementType<T> type, boolean withLibs) {
        return this.findElements(resource, (IFilter<IElement>)((IFilter)e -> this.testType((IElement)e, type)), withLibs);
    }

    public <T> List<T> findElements(IbeeResource resource, Class<T> clazz, boolean withLibs) {
        return this.findElements(resource, (IFilter<IElement>)((IFilter)e -> clazz.isAssignableFrom(e.getClass())), withLibs);
    }

    public List<IElement> findElements(IbeeResource resource, IFilter<IElement> filter, boolean withLibs) {
        ArrayList<IElement> result = new ArrayList<IElement>();
        if (resource == null) {
            return result;
        }
        if (this.considerMainResource) {
            IbeeResource mainResource = ModelUtilImf.getMainResource(resource);
            if (!withLibs && resource != mainResource) {
                throw new IbeeException("Cannot Find elements from main resource and lib resource if withLibs is set to false");
            }
            resource = mainResource;
        }
        this.findElementsInternal(resource, filter, result);
        if (withLibs) {
            for (IbeeLibrary lib : resource.getLibraries()) {
                IbeeResource libRes = lib.getResource();
                if (libRes == null) continue;
                this.findElementsInternal(libRes, filter, result);
            }
        }
        return result;
    }

    private void findElementsInternal(IbeeResource resource, IFilter<IElement> filter, List<IElement> result) {
        for (IElement e2 : resource.getAllObjects((IFilter<IElement>)((IFilter)e -> filter == null || filter.accept(e)))) {
            result.add(e2);
        }
    }

    public <T extends IElement> T findFirst(IbeeResource resource, IElementType<T> type, IAttributeFeature attrFeature, String value, boolean withLibs) {
        String attrName = attrFeature.getName();
        return (T)this.findFirst(resource, (IFilter<IElement>)((IFilter)element -> this.testType((IElement)element, type) && this.testAttribute((IElement)element, attrName, value)), withLibs);
    }

    public <T extends IElement> T findFirst(IbeeResource resource, IElementType<T> type, String attr, String value, boolean withLibs) {
        return (T)this.findFirst(resource, (IFilter<IElement>)((IFilter)element -> this.testType((IElement)element, type) && this.testAttribute((IElement)element, attr, value)), withLibs);
    }

    public <T extends IElement> T findFirst(IbeeResource resource, IElementType<T> type, IFilter<IElement> filter, boolean withLibs) {
        return (T)this.findFirst(resource, (IFilter<IElement>)((IFilter)element -> this.testType((IElement)element, type) && filter.accept(element)), withLibs);
    }

    public <T extends IElement> T findFirst(IbeeResource resource, IElementType<T> type, boolean withLibs) {
        return (T)this.findFirst(resource, (IFilter<IElement>)((IFilter)element -> this.testType((IElement)element, type)), withLibs);
    }

    public IElement findFirst(IbeeResource resource, IFilter<IElement> filter, boolean withLibs) {
        if (this.considerMainResource) {
            IbeeResource mainResource = ModelUtilImf.getMainResource(resource);
            if (!withLibs && resource != mainResource) {
                throw new IbeeException("Cannot Find elements from main resource and lib resource if withLibs is set to false");
            }
            resource = mainResource;
        }
        return resource.findFirst((IFilter<IElement>)((IFilter)e -> filter == null || filter.accept(e)));
    }

    public IFilter<IElement> createAttributeElementFilter(String attrName, String attrValue) {
        return el -> this.testAttribute((IElement)el, attrName, attrValue);
    }

    public boolean testAttribute(IElement element, String attr, String value) {
        String test;
        return element.giGetElementType().hasAttributeFeature(attr) && (test = element.giGetAttribute(attr)) != null && (this.ignoreCase ? test.equalsIgnoreCase(value) : test.equals(value));
    }

    public boolean testType(IElement element, IElementType<?> type) {
        return element.giGetElementType().inherits(type);
    }
}

