/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.edgemind.ibee.core.context.IContext;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.ImfComponent;
import net.edgemind.ibee.core.iml.model.ImfNamedElement;
import net.edgemind.ibee.core.iml.model.ImfReference;
import net.edgemind.ibee.core.io.IUserIO;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceFactory;
import net.edgemind.ibee.core.resource.ResourceIOException;
import net.edgemind.ibee.core.resource.reader.XmlImfResourceReaderDom;
import net.edgemind.ibee.core.resource.reader.sax.XmlImfResourceReaderSax;
import net.edgemind.ibee.core.resource.writer.sax.XmlImfResourceWriterSax;
import net.edgemind.ibee.core.util.ImfElementFilter;
import net.edgemind.ibee.core.util.ImfElementFinder;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.misc.IFilter;
import org.eclipse.core.runtime.IProgressMonitor;

public class ModelUtilImf {
    public static ImfComponent getRelevantComponent(IElement element) {
        if (element.giGetElementType().isReferenceType()) {
            element = ((ImfReference)element).resolve();
        }
        return (ImfComponent)ModelUtilImf.findParent(element, (IFilter<IElement>)((IFilter)el -> el.giGetElementType().isComponentType()));
    }

    public static ImfComponent getParentComponent(IElement element) {
        return (ImfComponent)ModelUtilImf.findParent(element, (IFilter<IElement>)((IFilter)e -> e != element && e.isComponent()));
    }

    public static IElement findParent(IElement element, IElementType<?> type) {
        return ModelUtilImf.findParent(element, (IFilter<IElement>)((IFilter)el -> el.giGetElementType() == type));
    }

    public static IElement findParent(IElement element, IFilter<IElement> filter) {
        if (element == null) {
            return null;
        }
        if (filter.accept((Object)element)) {
            return element;
        }
        return ModelUtilImf.findParent(element.giGetParent(), filter);
    }

    public static List<String> getAttributes(String attrName, List<? extends IElement> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (IElement iElement : list) {
            result.add(iElement.giGetAttribute(attrName));
        }
        return result;
    }

    public static List<IElement> getAllComponents(IbeeResource resource, ImfElementFilter filter) {
        ImfElementFinder finder = new ImfElementFinder();
        return finder.findElements(resource, (IFilter<IElement>)((IFilter)e -> e instanceof ImfComponent && (filter == null || filter.accept(e))), false);
    }

    public static List<IElement> getModules(IbeeResource resource, ImfElementFilter filter) {
        HashSet<IElement> modules = new HashSet<IElement>();
        ModelUtilImf.getModules(resource.getRoot(), modules, filter);
        return new ArrayList<IElement>(modules);
    }

    public static void getModules(IElement el, Set<IElement> modules, ImfElementFilter filter) {
        IElementType<? extends IElement> elType = el.giGetElementType();
        if (elType.isComponentType() && el.isModule() && (filter == null || filter.accept(el))) {
            modules.add(el);
        }
        for (IListFeature<IElement> feature : el.giGetElementType().getListFeatures()) {
            Collection<IElement> children;
            if (!feature.isContainment() || (children = el.giGetList(feature).getElements()) == null) continue;
            for (IElement child : children) {
                ModelUtilImf.getModules(child, modules, filter);
            }
        }
    }

    public static String getName(IElement el) {
        if (el.isNamed()) {
            return ((ImfNamedElement)el).getName();
        }
        return el.giGetAttribute("name");
    }

    public static IFeature getParentFeature(IElement e) {
        IElement parent = e.giGetParent();
        if (parent == null) {
            return null;
        }
        return parent.giGetFeatureOf(e);
    }

    public static IElement importElement(IElement from, IElement to, IFeature handle) {
        return ModelUtilImf.importElement(from, to, handle, false);
    }

    public static IElement importElement(IElement from, IElement to, IFeature handle, boolean onlyAttributes) {
        IElement clone = from.giGetElementType().getDomain().create(from.giGetElementType());
        if (handle instanceof IListFeature) {
            to.giGetList((IListFeature)handle).addElement(clone);
        } else {
            to.giGetElement((IElementFeature)handle).setElement(clone);
        }
        for (IAttributeFeature iAttributeFeature : from.giGetElementType().getAttributeFeatures()) {
            clone.giSetAttribute(iAttributeFeature, from.giGetAttribute(iAttributeFeature));
        }
        if (!onlyAttributes) {
            for (IListFeature iListFeature : from.giGetElementType().getListFeatures()) {
                if (!iListFeature.isContainment()) continue;
                for (Object e : from.giGetList(iListFeature).getElements()) {
                    ModelUtilImf.importElement(e, clone, iListFeature);
                }
            }
            for (IElementFeature iElementFeature : from.giGetElementType().getElementFeatures()) {
                Object e;
                if (!iElementFeature.isContainment() || (e = from.giGetElement(iElementFeature).getElement()) == null) continue;
                ModelUtilImf.importElement(e, clone, iElementFeature);
            }
        }
        return clone;
    }

    public static IbeeResource read(File file) throws ResourceIOException {
        return ModelUtilImf.read(file, null, null);
    }

    public static IbeeResource read(File file, IProgressMonitor monitor, ILogHandler logHandler) throws ResourceIOException {
        return ModelUtilImf.read(file, monitor, logHandler, null, null);
    }

    public static IbeeResource read(File file, IProgressMonitor monitor, ILogHandler logHandler, IbeeResource model) throws ResourceIOException {
        return ModelUtilImf.read(file, monitor, logHandler, null, model);
    }

    public static IbeeResource read(File file, IProgressMonitor monitor, ILogHandler logHandler, IUserIO userIo, IbeeResource model) throws ResourceIOException {
        if (model == null) {
            model = ResourceFactory.getInstance().createIbeeResource();
        }
        if (FileUtil.isZipFile((File)file)) {
            XmlImfResourceReaderSax reader = new XmlImfResourceReaderSax();
            try {
                reader.setIO(userIo);
                reader.setLogHandler(logHandler);
                reader.readModel(file, model, monitor);
            }
            catch (IOException e) {
                throw new ResourceIOException(e);
            }
        }
        XmlImfResourceReaderDom reader = new XmlImfResourceReaderDom();
        try {
            reader.setMonitor(monitor);
            reader.readModel(file.getAbsolutePath(), model);
        }
        catch (FileNotFoundException e) {
            throw new ResourceIOException(e);
        }
        catch (IOException e) {
            throw new ResourceIOException(e);
        }
        return model;
    }

    public static IbeeResource read(InputStream stream) throws ResourceIOException {
        return ModelUtilImf.read(stream, null, null, null, null);
    }

    public static IbeeResource read(InputStream in, IProgressMonitor monitor, ILogHandler logHandler, IUserIO userIo, IbeeResource model) throws ResourceIOException {
        BufferedInputStream stream;
        if (model == null) {
            model = ResourceFactory.getInstance().createIbeeResource();
        }
        try {
            stream = FileUtil.ensureBufferedInputStream((InputStream)in);
        }
        catch (IOException e1) {
            throw new ResourceIOException(e1);
        }
        if (FileUtil.isZipStream((BufferedInputStream)stream)) {
            XmlImfResourceReaderSax reader = new XmlImfResourceReaderSax();
            try {
                reader.setIO(userIo);
                reader.setLogHandler(logHandler);
                reader.readModel(stream, model, monitor);
            }
            catch (IOException e) {
                throw new ResourceIOException(e);
            }
        }
        XmlImfResourceReaderDom reader = new XmlImfResourceReaderDom();
        try {
            reader.setMonitor(monitor);
            reader.readModel(stream, model);
        }
        catch (FileNotFoundException e) {
            throw new ResourceIOException(e);
        }
        catch (IOException e) {
            throw new ResourceIOException(e);
        }
        return model;
    }

    public static <T extends IElement> List<T> sortByAttribute(final String attr, Collection<T> set) {
        ArrayList<T> list = new ArrayList<T>(set);
        Collections.sort(list, new Comparator<IElement>(){

            @Override
            public int compare(IElement o1, IElement o2) {
                return o1.giGetAttribute(attr).compareToIgnoreCase(o2.giGetAttribute(attr));
            }
        });
        return list;
    }

    public static List<IElementType<?>> sortElementTypeByName(List<IElementType<?>> elementTypes) {
        Collections.sort(elementTypes, new Comparator<IElementType<?>>(){

            @Override
            public int compare(IElementType<?> type1, IElementType<?> type2) {
                return type1.getName().compareToIgnoreCase(type2.getName());
            }
        });
        return elementTypes;
    }

    public static void updateElement(IElement element, IElement refElement) {
        for (IAttributeFeature feature : element.giGetElementType().getAttributeFeatures()) {
            String value = element.giGetAttribute(feature);
            if (value != null && !value.isEmpty()) continue;
            element.giSetAttribute(feature, refElement.giGetAttribute(feature));
        }
    }

    public static void write(IbeeResource resource, File file) throws ResourceIOException {
        XmlImfResourceWriterSax writer = new XmlImfResourceWriterSax();
        writer.setZipped(true);
        writer.write(resource, file);
    }

    public static void write(IbeeResource resource, OutputStream stream) throws ResourceIOException {
        XmlImfResourceWriterSax writer = new XmlImfResourceWriterSax();
        writer.setZipped(true);
        writer.write(resource, stream);
    }

    public static void remove(final IElement element, boolean withRefs, IbeeResource resource) {
        IElement parent = element.giGetParent();
        if (withRefs) {
            ImfElementFinder finder = new ImfElementFinder();
            List<IElement> references = finder.findElements(resource, new IFilter<IElement>(){

                public boolean accept(IElement object) {
                    if (object instanceof ImfReference) {
                        IElement findEl = ((ImfReference)object).resolve();
                        return findEl != null && findEl.equals(element);
                    }
                    return false;
                }
            }, false);
            references.forEach(ref -> resource.remove((IElement)ref, true));
        }
        if (parent != null) {
            IFeature feature = parent.giGetFeatureOf(element);
            if (feature instanceof IListFeature) {
                parent.giGetList((IListFeature)feature).removeElement(element);
            }
            if (feature instanceof IElementFeature) {
                parent.giGetElement((IElementFeature)feature).unset();
            }
        }
    }

    public static IbeeResource getMainResource(IbeeResource resource) {
        return ModelUtilImf.getMainResource(resource, resource.getContext());
    }

    public static IbeeResource getMainResource(IbeeResource resource, IContext context) {
        IbeeResource mainResource = context.getValue("main-resource", IbeeResource.class);
        return mainResource != null ? mainResource : resource;
    }

    public static void setMainResource(IbeeResource resource, IbeeResource mainResource) {
        ModelUtilImf.setMainResource(resource, mainResource, resource.getContext());
    }

    public static void setMainResource(IbeeResource resource, IbeeResource mainResource, IContext context) {
        context.setValue("main-resource", mainResource);
    }
}

