/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.builder.dom;

import java.util.Map;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaImage;
import net.edgemind.ibee.dita.items.DitaString;
import net.edgemind.ibee.dita.items.DitaTitle;
import net.edgemind.ibee.dita.items.DitaXRef;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ADitaElementDomBuilder<T extends DitaElement> {
    protected Document document;
    protected DitaElement ditaParent;
    protected String currentPath = "";
    protected boolean writeSingleDocument = true;

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setDitaParent(DitaElement ditaParent) {
        this.ditaParent = ditaParent;
    }

    public void setCurrentPath(String currentPath) {
        this.currentPath = currentPath;
    }

    public void writeSingleDocument(boolean writeSingleDocument) {
        this.writeSingleDocument = writeSingleDocument;
    }

    public boolean writeSingleDocument() {
        return this.writeSingleDocument;
    }

    public abstract Node createNode(T var1, Node var2);

    public Element printNode(T dita, String tagName) {
        Element element = this.document.createElement(tagName);
        this.printAttributes(dita, element);
        return element;
    }

    protected void printAttributes(T dita, Element element) {
        String value;
        this.printAttribute(element, "id", ((DitaElement)dita).getId());
        if (((DitaElement)dita).getOutputClasses() != null && ((DitaElement)dita).getOutputClasses().size() > 0) {
            this.writeClass(element, (DitaElement)dita);
        }
        if (((DitaElement)dita).getAttributes() != null) {
            for (String key : ((DitaElement)dita).getAttributes().keySet()) {
                value = ((DitaElement)dita).getAttributes().get(key);
                this.printAttribute(element, key, value);
            }
        }
        if (((DitaElement)dita).getUserAttributes() != null) {
            for (String key : ((DitaElement)dita).getUserAttributes().keySet()) {
                value = ((DitaElement)dita).getUserAttributes().get(key);
                this.printAttribute(element, key, value);
            }
        }
    }

    protected void printAttribute(Element element, String attr, String value) {
        if (value != null && !value.isEmpty() && value.length() > 0) {
            element.setAttribute(attr, value);
        }
    }

    protected <T extends DitaElement> void appendNodeAndSetBasicProperties(T dita, Element node, Node parent) {
        if (dita.getId() != null) {
            node.setAttribute("id", dita.getId());
        }
        this.writeUserAttributes(node, dita);
        this.appendNode(node, parent);
    }

    private void writeUserAttributes(Element node, DitaElement dita) {
        Map<String, String> userAttributes = dita.getUserAttributes();
        if (userAttributes != null) {
            for (String key : userAttributes.keySet()) {
                String value = userAttributes.get(key);
                node.setAttribute(key, value);
            }
        }
    }

    private void writeClass(Element node, DitaElement element) {
        if (node == null) {
            return;
        }
        Object value = "";
        for (String next : element.getOutputClasses()) {
            if (next == null) continue;
            if (((String)value).length() > 0) {
                value = (String)value + " ";
            }
            value = (String)value + next;
        }
        if (((String)value).length() > 0) {
            String currentValue = node.getAttribute("class");
            if (currentValue != null && currentValue.length() > 0) {
                value = (String)value + " " + currentValue;
            }
            node.setAttribute("class", (String)value);
        }
    }

    protected String getTitleTag(DitaTitle title) {
        if (title.getLevel() <= 0 || title.getLevel() > 6) {
            return "div";
        }
        return "h" + title.getLevel();
    }

    protected boolean containsComplicatedContent(DitaElement p) {
        boolean result = false;
        for (DitaElement child : p.getChildren()) {
            if (child instanceof DitaString || child instanceof DitaXRef || child instanceof DitaString || child instanceof DitaImage) continue;
            result = true;
            break;
        }
        return result;
    }

    protected void appendNode(Node xmlNode, Node xmlParent) {
        if (xmlNode == null) {
            return;
        }
        if (xmlParent == null) {
            this.document.appendChild(xmlNode);
        } else {
            xmlParent.appendChild(xmlNode);
        }
    }
}

