/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.builder.dom;

import net.edgemind.ibee.core.log.LogableAndMonitored;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaTopic;

public abstract class AbstractDocumentBuilder<T>
extends LogableAndMonitored {
    protected boolean writeSingleDocument = false;

    public void writeSingleDocument(boolean writeSingleDocument) {
        this.writeSingleDocument = writeSingleDocument;
    }

    public boolean writeSingleDocument() {
        return this.writeSingleDocument;
    }

    protected boolean isTopicElement(DitaElement ditaElement) {
        return ditaElement instanceof DitaTopic;
    }

    protected abstract <U extends DitaElement> T createNode(U var1, DitaElement var2, T var3);

    public void create(DitaElement element) {
        this.create(element, null, null);
    }

    public void create(DitaElement element, T parentNode) {
        this.create(element, null, parentNode);
    }

    protected final void create(DitaElement element, DitaElement parentItem, T parentNode) {
        T xmlNode = this.createNode(element, parentItem, parentNode);
        if (xmlNode == null) {
            xmlNode = parentNode;
        }
        if (!this.isExternalTopic(element, parentItem)) {
            for (DitaElement ditaChild : element.getChildren()) {
                this.create(ditaChild, element, xmlNode);
            }
        }
    }

    protected boolean isExternalTopic(DitaElement element, DitaElement parentItem) {
        return element instanceof DitaTopic && !this.isRootTopic(element, parentItem) && !this.writeSingleDocument();
    }

    private boolean isRootTopic(DitaElement element, DitaElement parentItem) {
        return element instanceof DitaTopic && parentItem == null;
    }
}

