/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.builder.dom;

import net.edgemind.ibee.dita.builder.dom.DitaTextElementDomBuilder;
import net.edgemind.ibee.dita.builder.dom.UrlCreator;
import net.edgemind.ibee.dita.items.DitaXRef;
import net.edgemind.ibee.util.file.FileUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DitaRefDomBuilder
extends DitaTextElementDomBuilder<DitaXRef> {
    @Override
    public Node createNode(DitaXRef ditaRef, Node parent) {
        Element node = super.printNode(ditaRef, "a");
        this.appendNodeAndSetBasicProperties(ditaRef, node, parent);
        if (ditaRef.getText() == null && ditaRef.getChildren().size() == 0) {
            node.setTextContent(this.getUrl(ditaRef));
        }
        return node;
    }

    private String getUrl(DitaXRef ditaRef) {
        Object url;
        if (this.writeSingleDocument) {
            url = ditaRef.getHref();
            String id = ((String)url).replaceAll("/", "-");
            url = "#" + id;
        } else {
            url = ditaRef.getHref();
            if (ditaRef.getFormat() == null) {
                url = FileUtil.replaceExtension((String)url, (String)".html");
                url = UrlCreator.createRelativeUrl(this.currentPath, (String)url);
            }
        }
        return url;
    }

    @Override
    protected void printAttributes(DitaXRef ditaRef, Element element) {
        super.printAttributes(ditaRef, element);
        this.printAttribute(element, "href", ditaRef.getHref());
        this.printAttribute(element, "format", ditaRef.getFormat());
        String url = this.getUrl(ditaRef);
        if (this.writeSingleDocument) {
            String href = url;
            this.printAttribute(element, "href", href);
        } else if (ditaRef.getFormat() == null) {
            String onclick = "javascript:makeUrl('" + url + "');";
            this.printAttribute(element, "onclick", onclick);
            String href = "javascript:void(0)";
            this.printAttribute(element, "href", href);
        } else if (ditaRef.getFormat().equals("js")) {
            String href = "javascript:void(0)";
            this.printAttribute(element, "href", href);
            String onclick = url.replace("javascript:", "");
            this.printAttribute(element, "onclick", onclick);
        }
    }
}

