/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.builder.dom;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.dita.builder.dom.DitaSectionDomBuilder;
import net.edgemind.ibee.dita.builder.dom.UrlCreator;
import net.edgemind.ibee.dita.items.DitaTopic;
import net.edgemind.ibee.util.file.FileUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DitaTopicDomBuilder
extends DitaSectionDomBuilder<DitaTopic> {
    private List<String> cssFiles = new ArrayList<String>();
    private List<String> jsFiles = new ArrayList<String>();

    public void setCssFiles(List<String> cssFiles) {
        this.cssFiles = cssFiles;
    }

    public void setJsFiles(List<String> jsFiles) {
        this.jsFiles = jsFiles;
    }

    public List<String> getCssFiles() {
        return this.cssFiles;
    }

    public List<String> getJsFiles() {
        return this.jsFiles;
    }

    @Override
    public Node createNode(DitaTopic dita, Node parent) {
        Element nodeToAppend = null;
        if (this.isExternalTopic()) {
            nodeToAppend = this.linkExternalTopic(dita);
            this.appendNodeAndSetBasicProperties(dita, nodeToAppend, parent);
        } else if (this.isRootTopic()) {
            nodeToAppend = this.createDocumentBody(dita, parent);
        }
        return nodeToAppend;
    }

    private boolean isExternalTopic() {
        return !this.isRootTopic() && !this.writeSingleDocument();
    }

    private boolean isRootTopic() {
        return this.ditaParent == null;
    }

    private Element linkExternalTopic(DitaTopic dita) {
        Element nodeToAppend = this.document.createElement("div");
        nodeToAppend.setAttribute("class", "topic");
        Element anchor = this.document.createElement("a");
        nodeToAppend.appendChild(anchor);
        String url = dita.getUrl();
        url = FileUtil.replaceExtension((String)url, (String)".html");
        url = UrlCreator.createRelativeUrl(this.currentPath, url);
        UrlCreator.createExternalUrl(anchor, url);
        return nodeToAppend;
    }

    private Element createDocumentBody(DitaTopic dita, Node parent) {
        Element node = this.printNode(dita, "html");
        this.createHeader(node);
        this.appendNodeAndSetBasicProperties(dita, node, parent);
        Element nodeToAppend = this.createBody(node);
        this.appendNodeAndSetBasicProperties(dita, nodeToAppend, node);
        return nodeToAppend;
    }

    private void createHeader(Element node) {
        List<String> jsFiles;
        Element head = this.document.createElement("head");
        node.appendChild(head);
        Element charsetMeta = this.document.createElement("meta");
        head.appendChild(charsetMeta);
        charsetMeta.setAttribute("charset", "UTF-8");
        List<String> cssFiles = this.getCssFiles();
        if (cssFiles != null) {
            for (String cssFile : cssFiles) {
                Element link = this.document.createElement("link");
                link.setAttribute("rel", "stylesheet");
                link.setAttribute("type", "text/css");
                String cssUrl = UrlCreator.createRelativeUrl(this.currentPath, cssFile);
                link.setAttribute("href", cssUrl);
                head.appendChild(link);
            }
        }
        if ((jsFiles = this.getJsFiles()) != null) {
            for (String jsFile : jsFiles) {
                Element script = this.document.createElement("script");
                script.setAttribute("type", "text/javascript");
                script.setTextContent("_");
                String jsUrl = UrlCreator.createRelativeUrl(this.currentPath, jsFile);
                script.setAttribute("src", jsUrl);
                head.appendChild(script);
            }
        }
    }

    private Element createBody(Element parent) {
        Element body = this.document.createElement("body");
        parent.appendChild(body);
        return body;
    }

    @Override
    protected void printAttributes(DitaTopic dita, Element element) {
        super.printAttributes(dita, element);
        String id = this.extractId(dita.getUrl());
        super.printAttribute(element, "id", id);
    }

    private String extractId(String url) {
        int index = url.indexOf(".");
        if (index >= 0) {
            return url.substring(0, index);
        }
        url = url.replaceAll("/", "-");
        return url;
    }
}

