/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.builder.dom;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.dita.builder.dom.ADitaElementDomBuilder;
import net.edgemind.ibee.dita.builder.dom.AbstractDocumentBuilder;
import net.edgemind.ibee.dita.builder.dom.DitaElementDomBuilderFactory;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaTopic;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class DomDocumentBuilder
extends AbstractDocumentBuilder<Node> {
    protected Document document;
    private List<String> cssFiles = new ArrayList<String>();
    private List<String> jsFiles = new ArrayList<String>();
    protected String currentUrl = "";

    public void setCssFiles(List<String> cssFiles) {
        this.cssFiles = cssFiles;
    }

    public void setJsFiles(List<String> jsFiles) {
        this.jsFiles = jsFiles;
    }

    public void setCurrentPath(String currentUrl) {
        this.currentUrl = currentUrl;
    }

    public Document buildTopicDocument(DitaTopic root) {
        this.document = XmlUtil.createNewDocument();
        this.appendDocType("topic", "-//OASIS//DTD DITA Topic//EN", "../../dtd/technicalContent/dtd/topic.dtd");
        this.create(root, null, null);
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    private void appendDocType(String type, String desc, String dtd) {
        DOMImplementation domImpl = this.document.getImplementation();
        DocumentType doctype = domImpl.createDocumentType(type, desc, dtd);
        this.document.appendChild(doctype);
    }

    public DitaElementDomBuilderFactory createBuilderFactory() {
        DitaElementDomBuilderFactory builderFactory = DitaElementDomBuilderFactory.createInstance();
        builderFactory.setDocument(this.document);
        builderFactory.writeSingleDocument(this.writeSingleDocument);
        builderFactory.setCurrentPath(this.currentUrl);
        builderFactory.setCssFiles(this.cssFiles);
        builderFactory.setJsFiles(this.jsFiles);
        return builderFactory;
    }

    @Override
    protected <T extends DitaElement> Node createNode(T element, DitaElement parentItem, Node parentNode) {
        if (element instanceof DitaTopic) {
            this.log("word document builder:writing topic '" + ((DitaTopic)element).getTitle() + "', file " + ((DitaTopic)element).getUrl(), LogLevel.INFO);
            this.interruptIfCancelled();
            this.worked(1);
        }
        Node node = null;
        ADitaElementDomBuilder<T> builder = this.createBuilderFactory().getDitaElementBuilder(element);
        if (builder != null) {
            builder.setDitaParent(parentItem);
            node = builder.createNode(element, parentNode);
        } else {
            this.debug("Ignore " + element.getClass().getSimpleName());
        }
        return node;
    }
}

