/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.builder.word;

import jakarta.xml.bind.JAXBElement;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.List;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.dita.builder.word.ADitaElementWordStylist;
import net.edgemind.ibee.dita.items.DitaElement;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;

public abstract class ADitaElementWordBuilder<T extends DitaElement>
extends ADitaElementWordStylist {
    protected ObjectFactory factory;
    protected WordprocessingMLPackage wordMLPackage;
    protected boolean useTemplate;

    public void setFactory(ObjectFactory factory) {
        this.factory = factory;
    }

    public void setWordProcessingPackage(WordprocessingMLPackage wordMLPackage) {
        this.wordMLPackage = wordMLPackage;
    }

    public void setUseTemplate(boolean template) {
        this.useTemplate = template;
    }

    public abstract ContentAccessor createNode(T var1, ContentAccessor var2);

    public void createBookmark(P p, R r, String bookmark, int id) {
        int index = p.getContent().indexOf(r);
        if (index < 0) {
            return;
        }
        BigInteger ID = BigInteger.valueOf(id);
        CTMarkupRange mr = this.factory.createCTMarkupRange();
        mr.setId(ID);
        JAXBElement bmEnd = this.factory.createBodyBookmarkEnd(mr);
        p.getContent().add(index + 1, bmEnd);
        CTBookmark bm = this.factory.createCTBookmark();
        bm.setId(ID);
        bm.setName(bookmark);
        JAXBElement bmStart = this.factory.createBodyBookmarkStart(bm);
        p.getContent().add(index, bmStart);
    }

    protected String getCorrectText(String content) {
        if (content == null) {
            return null;
        }
        String text = "";
        text = content.replaceAll("&gt;", ">");
        text = text.replaceAll("&lt;", "<");
        try {
            byte[] utf8Bytes = new byte[]{-50, -108};
            String delta = new String(utf8Bytes, "UTF-8");
            text = text.replaceAll("&Delta;", delta);
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.log((Throwable)e);
        }
        return text;
    }

    protected boolean useTemplate() {
        return this.useTemplate;
    }

    protected int getLargestPageWidth(int width) {
        List sections = this.wordMLPackage.getDocumentModel().getSections();
        int maxPageWidth = width;
        for (SectionWrapper section : sections) {
            PageDimensions pageDimensions = section.getPageDimensions();
            int currentPageWidth = pageDimensions.getWritableWidthTwips();
            maxPageWidth = Math.max(maxPageWidth, currentPageWidth);
        }
        if (width < maxPageWidth) {
            width = maxPageWidth;
        }
        return width;
    }
}

