/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.builder.word;

import net.edgemind.ibee.dita.builder.word.ADitaElementWordBuilder;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaEntry;
import net.edgemind.ibee.dita.style.StyleElement;
import net.edgemind.ibee.dita.writer.word.TableUtil;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;

public class DitaEntryWordBuilder
extends ADitaElementWordBuilder<DitaEntry> {
    protected String tableSize = "DIN A4, PORTRAIT";

    public void setTableSize(String tableSize) {
        this.tableSize = tableSize;
    }

    @Override
    public ContentAccessor createNode(DitaEntry dita, ContentAccessor parent) {
        Tc tableCell = this.factory.createTc();
        parent.getContent().add(tableCell);
        this.applyStyle(tableCell, (DitaElement)dita, null);
        String content = dita.getText();
        String text = this.getCorrectText(content);
        if (text == null || text.length() == 0) {
            if (dita.getChildren().size() > 0) {
                return tableCell;
            }
            text = "";
        }
        Text t = this.factory.createText();
        t.setValue(text);
        R run = this.factory.createR();
        run.getContent().add(t);
        P p = this.factory.createP();
        this.applyStyle(p, (DitaElement)dita);
        this.applyStyle(run, (DitaElement)dita);
        p.getContent().add(run);
        tableCell.getContent().add(p);
        if (dita.getId() != null && dita.getId().length() > 0) {
            this.createBookmark(p, run, dita.getId(), 123);
        }
        return tableCell;
    }

    protected void applyStyle(Tc tableCell, DitaElement element, String[] additionalStyles) {
        StyleElement styleElement = this.createStyleElement(element, additionalStyles);
        Integer tableWidth = this.styleEngine.getWidth(styleElement);
        int width = 9860;
        if (this.tableSize.equalsIgnoreCase("DIN A4, PORTRAIT")) {
            width = 9860;
        } else if (this.tableSize.equalsIgnoreCase("DIN A4, LANDSCAPE")) {
            width = 14790;
        } else if (this.tableSize.equalsIgnoreCase("DIN A3, PORTRAIT")) {
            width = 14790;
        } else if (this.tableSize.equalsIgnoreCase("DIN A3, LANDSCAPE")) {
            width = 21760;
        }
        if (this.useTemplate) {
            width = this.getLargestPageWidth(width);
        }
        if (tableWidth != null) {
            TableUtil.setCellWidth(tableCell, width * tableWidth / 100);
        }
    }
}

