/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.builder.word;

import java.io.File;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.dita.builder.word.ADitaElementWordBuilder;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaImage;
import net.edgemind.ibee.dita.style.StyleElement;
import net.edgemind.ibee.dita.util.DitaUtil;
import net.edgemind.ibee.dita.writer.word.AddingAnInlineImage;
import net.edgemind.ibee.util.file.FileUtil;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;

public class DitaImageWordBuilder
extends ADitaElementWordBuilder<DitaImage> {
    private File targetFolder;

    public void setTargetFolder(File folder) {
        this.targetFolder = folder;
    }

    @Override
    public ContentAccessor createNode(DitaImage dita, ContentAccessor parent) {
        String path = dita.getHref();
        if (path == null || path.length() == 0) {
            return null;
        }
        if (!DitaUtil.isAbsolute(path = path.replaceAll("%20", " "))) {
            path = new File(this.targetFolder, path).getAbsolutePath();
        }
        if (!FileUtil.fileExists((String)path)) {
            LogUtil.log((String)("error: file " + path + " not found"), (LogLevel)LogLevel.ERROR);
            return null;
        }
        P paragraph = null;
        try {
            if (parent instanceof P) {
                paragraph = (P)parent;
            } else {
                paragraph = this.factory.createP();
                parent.getContent().add(paragraph);
            }
            StyleElement styleElement = this.createStyleElement(dita, null);
            Integer imageWidth = this.styleEngine.getWidth(styleElement);
            if (imageWidth != null) {
                AddingAnInlineImage.createImage(path, this.wordMLPackage, paragraph, imageWidth);
            } else {
                AddingAnInlineImage.createImage(path, this.wordMLPackage, paragraph);
            }
            this.applyStyle(paragraph, (DitaElement)dita);
        }
        catch (Exception e) {
            throw new IbeeException((Throwable)e);
        }
        return paragraph;
    }
}

