/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.builder.word;

import java.io.File;
import net.edgemind.ibee.dita.builder.word.ADitaElementWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaBrWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaDescWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaEntryWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaImageWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaLiWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaNullWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaPWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaPreWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaRefWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaRowWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaSectionWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaStringWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaTableOfContentWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaTableWordBuilder;
import net.edgemind.ibee.dita.items.DitaDesc;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaEntry;
import net.edgemind.ibee.dita.items.DitaImage;
import net.edgemind.ibee.dita.items.DitaLi;
import net.edgemind.ibee.dita.items.DitaNl;
import net.edgemind.ibee.dita.items.DitaP;
import net.edgemind.ibee.dita.items.DitaPre;
import net.edgemind.ibee.dita.items.DitaRow;
import net.edgemind.ibee.dita.items.DitaSection;
import net.edgemind.ibee.dita.items.DitaString;
import net.edgemind.ibee.dita.items.DitaTBody;
import net.edgemind.ibee.dita.items.DitaTGroup;
import net.edgemind.ibee.dita.items.DitaTHead;
import net.edgemind.ibee.dita.items.DitaTable;
import net.edgemind.ibee.dita.items.DitaToc;
import net.edgemind.ibee.dita.items.DitaTopic;
import net.edgemind.ibee.dita.items.DitaUl;
import net.edgemind.ibee.dita.items.DitaXRef;
import net.edgemind.ibee.dita.style.DefaultStyleEngine;
import net.edgemind.ibee.dita.style.StyleEngine;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ObjectFactory;

public class DitaWordBuilderFactory {
    protected ObjectFactory factory;
    protected WordprocessingMLPackage wordMLPackage;
    protected StyleEngine styleEngine = new DefaultStyleEngine();
    protected String tableSize = "DIN A4, PORTRAIT";
    private File targetFolder;
    private boolean useTemplating;

    public static DitaWordBuilderFactory createInstance() {
        return new DitaWordBuilderFactory();
    }

    public void setWordObjectFactory(ObjectFactory factory) {
        this.factory = factory;
    }

    public void setWordProcessingPackage(WordprocessingMLPackage wordMLPackage) {
        this.wordMLPackage = wordMLPackage;
    }

    public void setStyleEngine(StyleEngine engine) {
        this.styleEngine = engine;
    }

    public void setTableSize(String tableSize) {
        this.tableSize = tableSize;
    }

    public void setTargetFolder(File folder) {
        this.targetFolder = folder;
    }

    public void setUseTemplating(boolean useTemplating) {
        this.useTemplating = useTemplating;
    }

    public <T extends DitaElement> ADitaElementWordBuilder<T> getDitaElementBuilder(T element) {
        ADitaElementWordBuilder builder = null;
        if (element instanceof DitaTopic) {
            builder = new DitaNullWordBuilder();
        } else if (element instanceof DitaSection) {
            builder = new DitaSectionWordBuilder();
        } else if (element instanceof DitaToc) {
            builder = new DitaTableOfContentWordBuilder();
        } else if (element instanceof DitaDesc) {
            builder = new DitaDescWordBuilder();
        } else if (element instanceof DitaString) {
            builder = new DitaStringWordBuilder();
        } else if (element instanceof DitaP) {
            builder = new DitaPWordBuilder();
        } else if (element instanceof DitaPre) {
            builder = new DitaPreWordBuilder();
        } else if (element instanceof DitaTable) {
            builder = new DitaTableWordBuilder();
            ((DitaTableWordBuilder)builder).setTableSize(this.tableSize);
        } else if (element instanceof DitaTGroup) {
            builder = new DitaNullWordBuilder();
        } else if (element instanceof DitaTBody) {
            builder = new DitaNullWordBuilder();
        } else if (element instanceof DitaTHead) {
            builder = new DitaNullWordBuilder();
        } else if (element instanceof DitaRow) {
            builder = new DitaRowWordBuilder();
        } else if (element instanceof DitaUl) {
            builder = new DitaNullWordBuilder();
        } else if (element instanceof DitaLi) {
            builder = new DitaLiWordBuilder();
        } else if (element instanceof DitaXRef) {
            builder = new DitaRefWordBuilder();
        } else if (element instanceof DitaImage) {
            builder = new DitaImageWordBuilder();
            ((DitaImageWordBuilder)builder).setTargetFolder(this.targetFolder);
        } else if (element instanceof DitaEntry) {
            builder = new DitaEntryWordBuilder();
            ((DitaEntryWordBuilder)builder).setTableSize(this.tableSize);
        } else if (element instanceof DitaNl) {
            builder = new DitaBrWordBuilder();
        }
        if (builder != null) {
            builder.setUseTemplate(this.useTemplating);
            builder.setFactory(this.factory);
            builder.setWordProcessingPackage(this.wordMLPackage);
            builder.setStyleEngine(this.styleEngine);
        }
        return builder;
    }
}

