/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.pandoc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.edgemind.ibee.dita.exception.DitaException;
import net.edgemind.ibee.dita.pandoc.PandocInputFormat;
import net.edgemind.ibee.dita.pandoc.PandocOutputFormat;

public class PandocConverter {
    public void convertToWord(String inputPath, PandocInputFormat inputFormat, String outputPath, String refPath) throws DitaException {
        String[] args = new String[]{"pandoc", "-f", inputFormat.toString().toLowerCase(), "-t", PandocOutputFormat.DOCX.toString(), "-o", outputPath, "--reference-docx=" + refPath, inputPath};
        this.convert(args);
    }

    public void convertToOdt(String inputPath, PandocInputFormat inputFormat, String outputPath, String refPath) throws DitaException {
        String[] args = new String[]{"pandoc", "-f", inputFormat.toString().toLowerCase(), "-t", PandocOutputFormat.ODT.toString(), "-o", outputPath, "--reference-odt=" + refPath, inputPath};
        this.convert(args);
    }

    public void convert(String inputPath, PandocInputFormat inputFormat, String outputPath, PandocOutputFormat outputFormat) throws DitaException {
        String[] args = new String[]{"pandoc", "-f", inputFormat.toString().toLowerCase(), "-t", outputFormat.toString().toLowerCase(), "-o", outputPath, inputPath};
        this.convert(args);
    }

    private void convert(String[] args) throws DitaException {
        try {
            Process p = Runtime.getRuntime().exec(args);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while (reader.ready()) {
                System.out.println(reader.readLine());
            }
            reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while (reader.ready()) {
                System.out.println(reader.readLine());
            }
        }
        catch (IOException e) {
            throw new DitaException(e);
        }
    }
}

