/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.template;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateKeyFinder {
    private String keyPrefix = "${";
    private String keySuffix = "}";
    private String keyValidChar = "A-Za-z0-9-_:() ";

    public List<String> getKeys(String line) {
        ArrayList<String> out = new ArrayList<String>();
        Matcher matcher = this.getPattern().matcher(line);
        while (matcher.find()) {
            out.add(matcher.group("placeholder"));
        }
        return out;
    }

    public String replaceKeys(String line, Function<String, String> resolver) {
        int lastIndex = 0;
        StringBuilder output = new StringBuilder();
        Matcher matcher = this.getMatcher(line);
        while (matcher.find()) {
            output.append(line, lastIndex, matcher.start()).append(resolver.apply(matcher.group("placeholder")));
            lastIndex = matcher.end();
        }
        if (lastIndex < line.length()) {
            output.append(line, lastIndex, line.length());
        }
        return output.toString();
    }

    public Matcher getMatcher(String line) {
        return this.getPattern().matcher(line);
    }

    private Pattern getPattern() {
        String prefix = Pattern.quote(this.getKeyPrefix());
        String suffix = Pattern.quote(this.getKeySuffix());
        return Pattern.compile(prefix + "(?<placeholder>[" + this.keyValidChar + "]+)" + suffix);
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public String getKeySuffix() {
        return this.keySuffix;
    }

    public void setKeySuffix(String keySuffix) {
        this.keySuffix = keySuffix;
    }

    public String getKeyValidChar() {
        return this.keyValidChar;
    }

    public void setKeyValidChar(String keyValidChar) {
        this.keyValidChar = keyValidChar;
    }
}

