/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.template;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import net.edgemind.ibee.core.exception.IbeeException;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.ObjectFactory;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.CTRel;
import org.docx4j.wml.CTSettings;

public class TemplateUtil {
    public static WordprocessingMLPackage getTemplate(String source, String target) throws Docx4JException, FileNotFoundException, IOException {
        String WORDPROCESSINGML_DOCUMENT = "application/vnd.openxmlformats-   officedocument.wordprocessingml.document.main+xml";
        new ContentType(WORDPROCESSINGML_DOCUMENT);
        String templatePath = source;
        File sourceFile = new File(source);
        File targetFile = new File(target);
        TemplateUtil.copyFileUsingFileChannels(sourceFile, targetFile);
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((InputStream)new FileInputStream(targetFile));
        ContentTypeManager ctm = wordMLPackage.getContentTypeManager();
        try {
            ctm.addOverrideContentType(new URI("/word/document.xml"), WORDPROCESSINGML_DOCUMENT);
        }
        catch (URISyntaxException e) {
            throw new IbeeException((Throwable)e);
        }
        DocumentSettingsPart dsp = new DocumentSettingsPart();
        CTSettings settings = Context.getWmlObjectFactory().createCTSettings();
        dsp.setJaxbElement((Object)settings);
        wordMLPackage.getMainDocumentPart().addTargetPart((Part)dsp);
        RelationshipsPart rp = RelationshipsPart.createRelationshipsPartForPart((Base)dsp);
        Relationship rel = new ObjectFactory().createRelationship();
        rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/attachedTemplate");
        rel.setTarget(templatePath);
        rel.setTargetMode("External");
        rp.addRelationship(rel);
        try {
            settings.setAttachedTemplate((CTRel)XmlUtils.unmarshalString((String)("<w:attachedTemplate xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"  xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" r:id=\"" + rel.getId() + "\"/>"), (JAXBContext)Context.jc, CTRel.class));
        }
        catch (JAXBException e) {
            throw new IbeeException((Throwable)e);
        }
        return wordMLPackage;
    }

    private static void copyFileUsingFileChannels(File source, File dest) throws IOException {
        AbstractInterruptibleChannel inputChannel = null;
        AbstractInterruptibleChannel outputChannel = null;
        try {
            inputChannel = new FileInputStream(source).getChannel();
            outputChannel = new FileOutputStream(dest).getChannel();
            ((FileChannel)outputChannel).transferFrom((ReadableByteChannel)((Object)inputChannel), 0L, ((FileChannel)inputChannel).size());
        }
        finally {
            inputChannel.close();
            outputChannel.close();
        }
    }
}

