/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.template.word;

import java.math.BigInteger;
import net.edgemind.ibee.dita.writer.word.AbstractNumHelper;
import net.edgemind.ibee.dita.writer.word.NumberingUtil;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.Body;
import org.docx4j.wml.Document;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.STLineSpacingRule;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Text;

public class DefaultWordTemplateCreator {
    private Integer fixTextSize;

    public void setTextSize(Integer fixTextSize) {
        this.fixTextSize = fixTextSize;
    }

    public WordprocessingMLPackage createDefaultTemplate() throws InvalidFormatException {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        NumberingUtil.initNumbering(wordMLPackage);
        Integer fixTitleSize = null;
        if (this.fixTextSize != null) {
            fixTitleSize = this.fixTextSize * 2;
        }
        AbstractNumHelper numHelper = new AbstractNumHelper();
        numHelper.setTitleSize(fixTitleSize);
        numHelper.createAbstractNum(wordMLPackage);
        this.createDefaultStyle(wordMLPackage);
        ObjectFactory factory = Context.getWmlObjectFactory();
        MainDocumentPart templateDocumentPart = wordMLPackage.getMainDocumentPart();
        Text t = factory.createText();
        t.setValue("${all}");
        R run = factory.createR();
        run.getContent().add(t);
        P p = factory.createP();
        templateDocumentPart.getContent().add(p);
        p.getContent().add(run);
        return wordMLPackage;
    }

    private void createDefaultStyle(WordprocessingMLPackage wordMLPackage) {
        Style style = wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart().getDefaultParagraphStyle();
        ObjectFactory factory = Context.getWmlObjectFactory();
        PPr paragraphProperties = factory.createPPr();
        PPrBase.Spacing sp = factory.createPPrBaseSpacing();
        sp.setLine(BigInteger.valueOf(276L));
        sp.setLineRule(STLineSpacingRule.AUTO);
        paragraphProperties.setSpacing(sp);
        style.setPPr(paragraphProperties);
        Body body = ((Document)wordMLPackage.getMainDocumentPart().getJaxbElement()).getBody();
        PageDimensions page = new PageDimensions();
        SectPr.PgMar pgMar = page.getPgMar();
        SectPr sectPr = factory.createSectPr();
        body.setSectPr(sectPr);
        sectPr.setPgMar(pgMar);
        pgMar.setLeft(BigInteger.valueOf(1022L));
        pgMar.setRight(BigInteger.valueOf(1022L));
        pgMar.setTop(BigInteger.valueOf(2266L));
        pgMar.setBottom(BigInteger.valueOf(1133L));
    }
}

