/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaEntry;
import net.edgemind.ibee.dita.items.DitaFactory;
import net.edgemind.ibee.dita.items.DitaImage;
import net.edgemind.ibee.dita.items.DitaLi;
import net.edgemind.ibee.dita.items.DitaP;
import net.edgemind.ibee.dita.items.DitaPre;
import net.edgemind.ibee.dita.items.DitaRow;
import net.edgemind.ibee.dita.items.DitaSection;
import net.edgemind.ibee.dita.items.DitaString;
import net.edgemind.ibee.dita.items.DitaTable;
import net.edgemind.ibee.dita.items.DitaTitle;
import net.edgemind.ibee.dita.items.DitaUl;
import net.edgemind.ibee.dita.items.DitaXRef;
import net.edgemind.ibee.dita.util.DitaUtil;

public class HtmlToDitaConverter {
    public static void htmlToDita(String content, DitaElement currentDiv, DitaElement body, int level) {
        String rest = content;
        String[] mo = rest.split("<");
        if (mo.length == 1) {
            DitaString p = DitaFactory.getInstance().createString();
            if (!(body instanceof DitaLi)) {
                p.addOutputClass("Indent" + level);
            }
            DitaUtil.appendString(mo[0], p);
            currentDiv.append(p);
            return;
        }
        ArrayList<DitaElement> ditaElements = new ArrayList<DitaElement>();
        DitaSection firstDiv = DitaFactory.getInstance().createSection();
        ditaElements.add(firstDiv);
        String[] stringArray = mo;
        int n = mo.length;
        int n2 = 0;
        while (n2 < n) {
            block111: {
                DitaSection nextDiv;
                String[] subTags;
                block113: {
                    DitaString span;
                    DitaElement element;
                    DitaP p;
                    String tagName;
                    String[] tagNames;
                    boolean close;
                    String tag;
                    block114: {
                        block112: {
                            String bulletin;
                            tag = stringArray[n2];
                            if (tag.length() == 0) break block111;
                            byte[] utf8Bytes = new byte[]{-17, -126, -73};
                            try {
                                bulletin = new String(utf8Bytes, "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new IbeeException((Throwable)e);
                            }
                            subTags = tag.split(bulletin);
                            close = false;
                            String nextTag = subTags[0];
                            if (!tag.contains(">")) {
                                DitaElement element2 = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                                DitaUtil.appendString(tag, element2);
                            } else if (tag.startsWith("/")) {
                                nextTag = tag.substring(1);
                                close = true;
                            }
                            tagNames = nextTag.split(">");
                            tagName = tagNames[0];
                            if (!tagName.equalsIgnoreCase("p") && !tagName.startsWith("p ")) break block112;
                            if (close) {
                                ditaElements.remove(ditaElements.size() - 1);
                                HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                            } else {
                                p = DitaFactory.getInstance().createP();
                                element = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                                element.append(p);
                                ditaElements.add(p);
                                if (!(element instanceof DitaLi)) {
                                    p.addOutputClass("Indent" + level);
                                }
                                if (tagNames.length > 1) {
                                    Object tagText = "";
                                    int i = 1;
                                    while (i < tagNames.length) {
                                        tagText = (String)tagText + tagNames[i];
                                        ++i;
                                    }
                                    DitaUtil.appendString((String)tagText, p);
                                }
                            }
                            break block113;
                        }
                        if (!tagName.equalsIgnoreCase("span") && !tagName.startsWith("span")) break block114;
                        if (close) {
                            ditaElements.remove(ditaElements.size() - 1);
                            HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                        } else {
                            span = DitaFactory.getInstance().createString();
                            element = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            element.append(span);
                            ditaElements.add(span);
                            span.addOutputClass("justify");
                            if (!(element instanceof DitaLi)) {
                                span.addOutputClass("Indent" + level);
                            }
                            if (tagNames.length > 1) {
                                Object tagText = "";
                                if (tagName.contains("border-top")) {
                                    tagText = "!";
                                }
                                int i = 1;
                                while (i < tagNames.length) {
                                    tagText = (String)tagText + tagNames[i];
                                    ++i;
                                }
                                DitaUtil.appendString((String)tagText, span);
                            }
                        }
                        break block113;
                    }
                    if (tagName.equalsIgnoreCase("ul") || tagName.startsWith("ul")) break block111;
                    if (tagName.equalsIgnoreCase("li") || tagName.startsWith("li")) {
                        if (close) {
                            nextDiv = DitaFactory.getInstance().createSection();
                            ditaElements.add(nextDiv);
                            HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, --level);
                        } else {
                            DitaLi li = DitaFactory.getInstance().createLi();
                            ditaElements.add(li);
                            li.addOutputClass("Level" + ++level);
                            if (tagNames.length > 1) {
                                tagText = "";
                                int i = 1;
                                while (i < tagNames.length) {
                                    tagText = (String)tagText + tagNames[i];
                                    ++i;
                                }
                                DitaUtil.appendString((String)tagText, li);
                            }
                        }
                    } else if (tagName.equalsIgnoreCase("pre") || tagName.startsWith("pre")) {
                        if (close) {
                            ditaElements.remove(ditaElements.size() - 1);
                            HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                        } else {
                            p = DitaFactory.getInstance().createP();
                            DitaPre pre = DitaFactory.getInstance().createPre();
                            p.append(pre);
                            DitaElement element3 = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            element3.append(p);
                            ditaElements.add(p);
                            if (!(element3 instanceof DitaLi)) {
                                p.addOutputClass("Indent" + level);
                                pre.addOutputClass("Indent" + level);
                            }
                            if (tagNames.length > 1) {
                                Object tagText = "";
                                int i = 1;
                                while (i < tagNames.length) {
                                    tagText = (String)tagText + tagNames[i];
                                    ++i;
                                }
                                DitaUtil.appendString((String)tagText, pre);
                            }
                        }
                    } else if (tagName.equalsIgnoreCase("i") || tagName.startsWith("i ")) {
                        if (close) {
                            element = (DitaElement)ditaElements.remove(ditaElements.size() - 1);
                            DitaUtil.propagateStyle(element, "italic");
                            HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                        } else {
                            span = DitaFactory.getInstance().createString();
                            element = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            element.append(span);
                            ditaElements.add(span);
                            span.addOutputClass("justify");
                            if (!(element instanceof DitaLi)) {
                                span.addOutputClass("Indent" + level);
                            }
                            if (tagNames.length > 1) {
                                Object tagText = "";
                                int i = 1;
                                while (i < tagNames.length) {
                                    tagText = (String)tagText + tagNames[i];
                                    ++i;
                                }
                                DitaUtil.appendString((String)tagText, span);
                            }
                        }
                    } else if (tagName.equalsIgnoreCase("u") || tagName.startsWith("u ")) {
                        if (close) {
                            element = (DitaElement)ditaElements.remove(ditaElements.size() - 1);
                            DitaUtil.propagateStyle(element, "underline");
                            HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                        } else {
                            span = DitaFactory.getInstance().createString();
                            element = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            element.append(span);
                            ditaElements.add(span);
                            span.addOutputClass("justify");
                            if (!(element instanceof DitaLi)) {
                                span.addOutputClass("Indent" + level);
                            }
                            if (tagNames.length > 1) {
                                Object tagText = "";
                                int i = 1;
                                while (i < tagNames.length) {
                                    tagText = (String)tagText + tagNames[i];
                                    ++i;
                                }
                                DitaUtil.appendString((String)tagText, span);
                            }
                        }
                    } else if (tagName.equalsIgnoreCase("b") || tagName.startsWith("b ")) {
                        if (close) {
                            element = (DitaElement)ditaElements.remove(ditaElements.size() - 1);
                            DitaUtil.propagateStyle(element, "bold");
                            HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                        } else {
                            span = DitaFactory.getInstance().createString();
                            element = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            element.append(span);
                            ditaElements.add(span);
                            span.addOutputClass("justify");
                            if (!(element instanceof DitaLi)) {
                                span.addOutputClass("Indent" + level);
                            }
                            if (tagNames.length > 1) {
                                Object tagText = "";
                                int i = 1;
                                while (i < tagNames.length) {
                                    tagText = (String)tagText + tagNames[i];
                                    ++i;
                                }
                                DitaUtil.appendString((String)tagText, span);
                            }
                        }
                    } else if (tagName.equalsIgnoreCase("table") || tagName.startsWith("table")) {
                        if (close) {
                            element = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            if (element instanceof DitaTable) {
                                DitaUtil.removeEmptyRow((DitaTable)element);
                            }
                            ditaElements.remove(ditaElements.size() - 1);
                            HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                        } else {
                            DitaSection div = DitaFactory.getInstance().createSection();
                            element = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            element.append(div);
                            DitaTable table = DitaFactory.getInstance().createTable();
                            div.append(table);
                            ditaElements.add(table);
                        }
                    } else if (tagName.equalsIgnoreCase("tr") || tagName.startsWith("tr")) {
                        if (close) {
                            ditaElements.remove(ditaElements.size() - 1);
                            HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                        } else {
                            DitaRow tr = DitaFactory.getInstance().createRow();
                            element = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            element.append(tr);
                            ditaElements.add(tr);
                        }
                    } else if (tagName.equalsIgnoreCase("th") || tagName.startsWith("th")) {
                        if (close) {
                            ditaElements.remove(ditaElements.size() - 1);
                            HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                        } else {
                            DitaEntry th = DitaFactory.getInstance().createEntry();
                            element = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            element.append(th);
                            ditaElements.add(th);
                            if (tagNames.length > 1) {
                                Object tagText = "";
                                int i = 1;
                                while (i < tagNames.length) {
                                    tagText = (String)tagText + tagNames[i];
                                    ++i;
                                }
                                DitaUtil.appendString((String)tagText, th);
                            }
                        }
                    } else if (tagName.equalsIgnoreCase("td") || tagName.startsWith("td")) {
                        if (close) {
                            ditaElements.remove(ditaElements.size() - 1);
                            HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                        } else {
                            DitaEntry td = DitaFactory.getInstance().createEntry();
                            element = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            element.append(td);
                            ditaElements.add(td);
                            if (tagNames.length > 1) {
                                Object tagText = "";
                                int i = 1;
                                while (i < tagNames.length) {
                                    tagText = (String)tagText + tagNames[i];
                                    ++i;
                                }
                                DitaUtil.appendString((String)tagText, td);
                            }
                        }
                    } else if (tagName.equalsIgnoreCase("br/") || tagName.startsWith("br") && tagName.endsWith("/")) {
                        DitaElement lastDitaElement = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                        if (!(lastDitaElement instanceof DitaLi)) {
                            lastDitaElement = (DitaElement)ditaElements.remove(ditaElements.size() - 1);
                            DitaElement previousDitaElement = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            DitaElement emptyCopyOfLastDitaElement = DitaUtil.createCopyDita(lastDitaElement);
                            previousDitaElement.append(emptyCopyOfLastDitaElement);
                            DitaP p2 = DitaFactory.getInstance().createP();
                            emptyCopyOfLastDitaElement.append(p2);
                            ditaElements.add(emptyCopyOfLastDitaElement);
                            lastDitaElement = emptyCopyOfLastDitaElement;
                        }
                        if (tagNames.length > 1) {
                            tagText = "";
                            int i = 1;
                            while (i < tagNames.length) {
                                tagText = (String)tagText + tagNames[i];
                                ++i;
                            }
                            DitaUtil.appendString((String)tagText, lastDitaElement);
                        }
                    } else if (tagName.startsWith("a")) {
                        if (close) {
                            HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                        } else {
                            String tagText = "<" + tag + "</a>";
                            DitaXRef ref = HtmlToDitaConverter.createXRef(tagText);
                            DitaElement element4 = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            element4.append(ref);
                        }
                    } else if (tagName.startsWith("h")) {
                        if (close) {
                            ditaElements.remove(ditaElements.size() - 1);
                            HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                        } else {
                            p = DitaFactory.getInstance().createP();
                            DitaSection section = DitaFactory.getInstance().createSection();
                            DitaTitle title = DitaFactory.getInstance().createTitle();
                            title.setLevel(Integer.valueOf(tagName.substring(1, tagName.indexOf(" "))));
                            section.append(title);
                            p.append(section);
                            DitaElement element5 = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            element5.append(p);
                            ditaElements.add(p);
                            if (!(element5 instanceof DitaLi)) {
                                p.addOutputClass("Indent" + level);
                            }
                            if (tagNames.length > 1) {
                                Object tagText = "";
                                int i = 1;
                                while (i < tagNames.length) {
                                    tagText = (String)tagText + tagNames[i];
                                    ++i;
                                }
                                title.setText((String)tagText);
                            }
                        }
                    } else if (tagName.contains("img")) {
                        if (close) {
                            ditaElements.remove(ditaElements.size() - 1);
                            HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                        } else {
                            String splitTagSrc;
                            String[] splitSrcValues;
                            element = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                            String[] splitTagValues = tagName.split("src=");
                            if (splitTagValues.length > 0 && (splitSrcValues = (splitTagSrc = splitTagValues[1]).split("\"")).length > 0) {
                                String imgPath = splitSrcValues[1];
                                if (imgPath.startsWith("file:/")) {
                                    imgPath = imgPath.substring(6);
                                }
                                DitaImage img = DitaFactory.getInstance().createImage();
                                img.setHref(imgPath);
                                img.addOutputClass("display_block");
                                element.append(img);
                                if (!(element instanceof DitaLi)) {
                                    img.addOutputClass("Indent" + level);
                                }
                            }
                            if (tagNames.length > 1) {
                                Object tagText = "";
                                int i = 1;
                                while (i < tagNames.length) {
                                    tagText = (String)tagText + tagNames[i];
                                    ++i;
                                }
                                DitaUtil.appendString((String)tagText, element);
                            }
                        }
                    } else if (close) {
                        ditaElements.remove(ditaElements.size() - 1);
                        HtmlToDitaConverter.completePreviousDita(tagNames, ditaElements, level);
                    } else {
                        span = DitaFactory.getInstance().createString();
                        element = (DitaElement)ditaElements.get(ditaElements.size() - 1);
                        element.append(span);
                        ditaElements.add(span);
                        span.addOutputClass("justify");
                        if (!(element instanceof DitaLi)) {
                            span.addOutputClass("Indent" + level);
                        }
                        if (tagNames.length > 1) {
                            Object tagText = "";
                            int i = 1;
                            while (i < tagNames.length) {
                                tagText = (String)tagText + tagNames[i];
                                ++i;
                            }
                            DitaUtil.appendString((String)tagText, span);
                        }
                    }
                }
                if (subTags.length > 1) {
                    int j = 1;
                    while (j < subTags.length) {
                        DitaLi li = DitaFactory.getInstance().createLi();
                        ditaElements.add(li);
                        li.addOutputClass("Level" + (level + 1));
                        DitaUtil.appendString(subTags[j], li);
                        ++j;
                    }
                    nextDiv = DitaFactory.getInstance().createSection();
                    ditaElements.add(nextDiv);
                }
            }
            ++n2;
        }
        for (DitaElement ditaElement : ditaElements) {
            if (ditaElement instanceof DitaLi) {
                DitaUl subUl = DitaFactory.getInstance().createUl();
                body.append(subUl);
                subUl.append(ditaElement);
                continue;
            }
            body.append(ditaElement);
        }
    }

    private static void completePreviousDita(String[] tagNames, List<DitaElement> ditaElements, int level) {
        if (ditaElements.size() == 0) {
            return;
        }
        DitaElement element = ditaElements.get(ditaElements.size() - 1);
        if (tagNames.length > 1) {
            Object tagText = "";
            int i = 1;
            while (i < tagNames.length) {
                tagText = (String)tagText + tagNames[i];
                ++i;
            }
            DitaUtil.appendString((String)tagText, element);
        }
    }

    private static DitaXRef createXRef(String value) {
        DitaXRef ref = DitaFactory.getInstance().createXRef();
        String pattern = "<a href=(.*?)>(.*?)</a>";
        Pattern p = Pattern.compile(pattern, 2);
        Matcher matcher = p.matcher(value);
        if (matcher.find()) {
            String urlString = matcher.group(1);
            String name = matcher.group(2);
            ref.setHref(urlString);
            ref.setText(name);
        }
        return ref;
    }
}

