/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer;

import java.io.File;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.dita.builder.dom.DomDocumentBuilder;
import net.edgemind.ibee.dita.exception.DitaException;
import net.edgemind.ibee.dita.items.DitaTopic;
import net.edgemind.ibee.dita.writer.AbstractTopicWriter;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;

public abstract class DomDocumentWriter
extends AbstractTopicWriter {
    public void createDomDocument(DitaTopic topic, File outputFolder) throws DitaException {
        this.verify(topic);
        DomDocumentBuilder documentBuilder = (DomDocumentBuilder)this.createDocumentBuilder();
        documentBuilder.setCurrentPath(topic.getUrl());
        Document document = documentBuilder.buildTopicDocument(topic);
        File file = new File(outputFolder, this.getFileName(topic));
        this.write(document, file);
        XmlUtil.destroy((Document)document);
        document = null;
    }

    protected void write(Document doc, File file) {
        try {
            FileUtil.createDir((String)file.getParent());
            XmlUtil.writeXmlFile((Document)doc, (File)file);
        }
        catch (Exception e) {
            throw new IbeeException((Throwable)e);
        }
    }
}

